package org.petalslink.easiestdemo.wsoui.core.bpel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class WindowsScriptsGenerator {
	
	private static final String SCRIPTS = "scripts";
	
	private static final String GLOBAL_SCRIPTS = "global-scripts";

	private String projectName;

	private String version;

	private List<String> allServerClassNames;

	private BPELProcess process;

	private boolean override;

	public WindowsScriptsGenerator(String projectName, String version, BPELProcess process, List<String> allServerClassNames, boolean override) throws WSOUIException {
		this.allServerClassNames = allServerClassNames;
		this.process = process;
		this.override = override;
		this.projectName = projectName;
		this.version = version;
	}


	public File generateScript(String fileName, String className, String basedir) throws IOException {
		File scriptDir = new File(basedir + "/" + SCRIPTS);
		scriptDir.mkdirs();
		File res = FileUtil.createFile(fileName, basedir + "/" + SCRIPTS, ".bat", this.override);
		FileWriter writer = null;
		try {
			writer = new FileWriter(res);
			writer.write("@Echo Off\n");
			writer.write("Rem verif variables:\n");
			writer.write(":checkjavahome\n");
			writer.write("if \"%JAVA_HOME%\" == \"\" (\n");
			writer.write("			echo The JAVA_HOME variable is not set. Please initialise it in your environment.\n");
			writer.write("			goto :EOF\n");
			writer.write(") else (\n");
			writer.write("			set PATH = %JAVA_HOME%\\bin;%PATH%\n");
			writer.write("			goto checkjavaopts\n");
			writer.write(")\n");


			writer.write(":checkjavaopts\n");
			writer.write("if \"%JAVA_OPTS%\" == \"\" (\n");
			writer.write("			set JAVA_OPTS=-Xmx256m\n");
			writer.write(")\n");
			writer.write("goto start\n");


			writer.write(":start\n");
			writer.write("echo launching " + className + " with command line :\n");
			writer.write("echo java %JAVA_OPTS% -cp \"" + this.projectName + "-" + this.version + ".jar\" " + className + " standalone \n");
			writer.write("java %JAVA_OPTS% -cp \"" + this.projectName + "-" + this.version + ".jar\" " + className + " standalone \n");

		} finally{
			if(writer != null){
				writer.close();
			}
		}
		return res;
	}


	public List<File> generateAllScripts(String basedir) throws IOException {
		List<File> res = new ArrayList<File>();
		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.process.getTargetNamespace());
		String className = this.process.getName() + "_Main";
		className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
		res.add(this.generateScript("StartBPEL_" + this.process.getName(), packageName + "." + className, basedir));
		for(String providerClass: this.allServerClassNames) {
			res.add(this.generateScript("StartProvider_" + FileUtil.createShortClassName(providerClass), providerClass, basedir));
		}
		res.add(this.generateStartESBScript(basedir));
		res.add(this.generateStartProvidersScript(basedir));
		res.add(this.generateStartAllScript(basedir));
		return res;
	}


	private File generateStartAllScript(String basedir) throws IOException {
		File scriptDir = new File(basedir + "/" + GLOBAL_SCRIPTS);
		scriptDir.mkdirs();
		File res = FileUtil.createFile("StartAll", basedir + "/" + GLOBAL_SCRIPTS, ".bat", this.override);
		FileWriter writer = null;
		try {
			writer = new FileWriter(res);
			writer.write("echo \"START All\"\n");
			writer.write("start StartProviders.bat\n");
			writer.write("start StartESB.bat\n");
		} finally{
			if(writer != null){
				writer.close();
			}
		}
		return res;
	}


	private File generateStartProvidersScript(String basedir) throws IOException {
		File scriptDir = new File(basedir + "/" + GLOBAL_SCRIPTS);
		scriptDir.mkdirs();
		File res = FileUtil.createFile("StartProviders", basedir + "/" + GLOBAL_SCRIPTS, ".bat", this.override);
		FileWriter writer = null;
		try {
			writer = new FileWriter(res);
			writer.write("echo \"START All providers\"\n");
			writer.write("cd bin\n");
			for(String providerClass: this.allServerClassNames) {
				writer.write("start StartProvider_" + FileUtil.createShortClassName(providerClass) + ".bat\n");
			}
		} finally{
			if(writer != null){
				writer.close();
			}
		}
		return res;
	}


	private File generateStartESBScript(String basedir) throws IOException {
		File scriptDir = new File(basedir + "/" + GLOBAL_SCRIPTS);
		scriptDir.mkdirs();
		File res = FileUtil.createFile("StartESB", basedir + "/" + GLOBAL_SCRIPTS, ".bat", this.override);
		FileWriter writer = null;
		try {
			writer = new FileWriter(res);
			writer.write("echo \"START EasyESB\"\n");
			writer.write("cd bin\n");
			writer.write("start StartBPEL_" + this.process.getName() + ".bat\n");
		} finally{
			if(writer != null){
				writer.close();
			}
		}
		return res;
	}





}
