package org.petalslink.easiestdemo.wsoui.core.reflexive;

import java.util.List;

public class Method {

	private String name;
	
	private Parameter outputParam;
	
	private List<Parameter> inputParams;
	
	private List<String> exceptions;
	

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Parameter getOutputParam() {
		return outputParam;
	}

	public void setOutputParam(Parameter outputParams) {
		this.outputParam = outputParams;
	}

	public List<Parameter> getInputParams() {
		return inputParams;
	}

	public void setInputParams(List<Parameter> inputParams) {
		this.inputParams = inputParams;
	}

	public List<String> getExceptions() {
		return exceptions;
	}

	public void setExceptions(List<String> exceptions) {
		this.exceptions = exceptions;
	}

	@Override
	public String toString() {
		return "Method [name=" + name + ", outputParams=" + outputParam
				+ ", inputParams=" + inputParams + ", exceptions=" + exceptions
				+ "]";
	}
	
	public static String generateListOfInputParameterNames(Method m) {
		String res = "";
		for(Parameter p: m.getInputParams()) {
			res = res + p.getName() + ", ";
		}
		res = res.substring(0, res.length() - ", ".length());
		return res;
	}
}
