package org.petalslink.easiestdemo.wsoui.core.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.core.reflexive.ImplMetaInf;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Method;
import org.petalslink.easiestdemo.wsoui.core.reflexive.Parameter;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


public class TestImplementationGenerator {

	private ImplMetaInf imf;
	private String tns;

	public TestImplementationGenerator(String tns, ImplMetaInf imf) throws WSOUIException {
		this.imf = imf;
		this.tns = tns;
	}



	private String generateImplementationMethod(Method m) {
		String res = "";
		res = "" + 
		"       Exchange<?, ?, ?> ex = this.getExchangeProcessor().match(\"" + m.getName() + "\", " + Method.generateListOfInputParameterNames(m) + ");\r\n"; 
		if(!m.getOutputParam().getType().equals("void")) {
			res = res + "		if(ex == null) {\r\n" + 
			"			return " + Parameter.returnDefaultType(m.getOutputParam().getType()) + ";\r\n" + 
			"		}\n";
		}
		res = res + "		if(ex.getExpectedFault() != null) {\r\n";

		for(String exception: m.getExceptions()) {
			res = res + 
			"			if(ex.getExpectedFault() instanceof " + exception + ") {\r\n" +
			"				throw (" + exception + ")ex.getExpectedFault();\r\n" + 
			"			} else ";
		}

		res = res + " {\r\n" + 
		"				throw new RuntimeException(\"Fault unknown: \" + ex.getExpectedFault());\r\n" + 
		"			}\r\n" + 
		"		}\r\n";
		if(!m.getOutputParam().getType().equals("void")) {
			res = res + "		return (" + Parameter.findType(m.getOutputParam().getType()) + ") ex.getExpectedResponse();";
		}
		return res;
	}


	public File generate(String basedir) throws IOException {
		String className = imf.getServiceName().substring(0, 1).toUpperCase() + imf.getServiceName().substring(1, imf.getServiceName().length());
		className = className + "TestImplementation";

		String packageName = FileUtil.createPackageNameFromTargetNamespace(this.tns);

		File f = new File(basedir + "/" + packageName.replace(".", "/") + "/" + className + ".java");

		FileWriter writer = null;
		try {
			writer = new FileWriter(f);

			// create package
			writer.write("package " + packageName + ";\n");
			writer.write("\n");

			// create imports
			for(String impt: imf.getImports()) {
				writer.write("import " + impt + ";\n");
			}
			// add specific import
			writer.write("import " + imf.getSignaturePackage() + "." + imf.getInterfaceName() + ";\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractTestImplementation;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.AbstractExchangeProcessor;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.provided.Exchange;\n");
			writer.write("import org.petalslink.easiestdemo.wsoui.core.WSOUIException;\n");

			writer.write("\n");


			// create class
			writer.write("public class " + className + " extends AbstractTestImplementation implements " + imf.getInterfaceName() + "{\n");
			writer.write("\n");

			// create constructor
			writer.write("\tpublic " + className + "(AbstractExchangeProcessor aep) throws WSOUIException {\n");
			writer.write("\t\tsuper(aep);\n");
			writer.write("\t}\n");
			writer.write("\n");

			// create all methods
			for(Method m: imf.getSignatureMethods()) {
				writer.write("\tpublic " + m.getOutputParam().getType() + " " + m.getName() + "(" );

				// create input params
				String inputParams = "";
				for(Parameter inputParam: m.getInputParams()) {
					inputParams = inputParams + inputParam.getType() + " " + inputParam.getName() + ", ";
				}
				inputParams = inputParams.substring(0, inputParams.length() - ", ".length()) + ") ";
				writer.write(inputParams);

				// create exception if exists
				if(m.getExceptions() != null && m.getExceptions().size() > 0) {
					writer.write(" throws ");
					String exceptions = "";
					for(String exception: m.getExceptions()) {
						exceptions = exceptions + exception + ", ";
					}
					exceptions = exceptions.substring(0, exceptions.length() - ", ".length());
					writer.write(exceptions);
				}
				writer.write(" {\n");
				writer.write(this.generateImplementationMethod(m));
				writer.write("\t}\n\n\n");
			}

			writer.write("\n");
			writer.write("}\n");



		} finally{
			if(writer != null){
				writer.close();
			}
		}

		return f;
	}
}
