package org.petalslink.easiestdemo.wsoui.core.reflexive;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.io.FileReader;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class ImplMetaInf {

	private String signaturePackage;

	private List<String> signatureImports;

	private String className;

	private String interfaceName;

	private String serviceName;

	private String endpointName;

	private String wsdlLocation;

	private String targetNamespace;

	private List<String> signatureStateVariable;

	private List<Method> signatureMethods;

	private List<Annotation> annotationClass;

	private ProviderConfiguration conf = new ProviderConfiguration();

	private File wsdl;


	public ImplMetaInf(File cxfImplementation, File wsdl) throws WSOUIException {
		try {

                        Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "File : "+cxfImplementation);
			FileReader fr = new FileReader(cxfImplementation);

			List<String> linesWithoutComments = this.deleteAllComments(fr.getLines()); 

			this.signaturePackage = this.findPackage(linesWithoutComments);
			this.signatureImports = this.findAllImports(linesWithoutComments);
			this.annotationClass = this.findAllClassAnnotation(linesWithoutComments);
			this.className = this.findClassName(linesWithoutComments);
			this.interfaceName = this.findInterfaceName(linesWithoutComments);
			this.signatureStateVariable = this.findAllStateVariables(linesWithoutComments);
			this.signatureMethods = this.findAllMethods(linesWithoutComments, cxfImplementation);
			//	this.endpointAddress = this.findEndpointAddress()

			this.serviceName = this.findServiceName(this.annotationClass);
			this.endpointName = this.findEndpointName(this.annotationClass);
			this.wsdlLocation = this.findWsdlLocation(this.annotationClass);
			this.targetNamespace = this.findTargetNamespace(this.annotationClass);
		} catch (SOAException e) {
			throw new WSOUIException(e);
		}
	}

	private String findEndpointName(List<Annotation> annotationClass) {
		String res = null;
		for(Annotation a: annotationClass) {
			if(a.getFields().get("portName") != null) {
				res = a.getFields().get("portName").replace("\"", "");
				break;
			}
		}
		return res;
	}

	private String findWsdlLocation(List<Annotation> annotationClass) {
		String res = null;
		for(Annotation a: annotationClass) {
			if(a.getFields().get("wsdlLocation") != null) {
				res = a.getFields().get("wsdlLocation");
				if(res.contains("/main/resources/")) {
					res = res.substring(res.indexOf("/main/resources/") + "/main/resources/".length(), res.length()).replace("\"", "");;
				} else if(res.contains("/test/resources/")) {
					res = res.substring(res.indexOf("/test/resources/") + "/test/resources/".length(), res.length()).replace("\"", "");;
				} else if(res.contains("/classes/")) {
					res = res.substring(res.indexOf("/classes/") + "/classes/".length(), res.length()).replace("\"", "");;
				} else if(res.contains("/test-classes/")) {
					res = res.substring(res.indexOf("/test-classes/") + "/test-classes/".length(), res.length()).replace("\"", "");;
				} 
				break;
			}
		}
		return res;
	}

	private String findServiceName(List<Annotation> annotationClass) {
		String res = null;
		for(Annotation a: annotationClass) {
			if(a.getFields().get("serviceName") != null) {
				res = a.getFields().get("serviceName").replace("\"", "");;
				break;
			}
		}
		return res;
	}

	private String findTargetNamespace(List<Annotation> annotationClass) {
		String res = null;
		for(Annotation a: annotationClass) {
			if(a.getFields().get("targetNamespace") != null) {
				res = a.getFields().get("targetNamespace").replace("\"", "");;
				break;
			}
		}
		return res;
	}

	public String getServiceName() {
		return serviceName;
	}

	public String getEndpointName() {
		return endpointName;
	}

	public ProviderConfiguration getConf() {
		return conf;
	}


	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getInterfaceName() {
		return interfaceName;
	}

	public void setInterfaceName(String interfaceName) {
		this.interfaceName = interfaceName;
	}

	public List<String> getImports() {
		return this.signatureImports;
	}

	public void setImports(List<String> imports) {
		this.signatureImports = imports;
	}

	public List<Method> getSignatureMethods() {
		return signatureMethods;
	}

	public void setSignatureMethods(List<Method> signatureMethods) {
		this.signatureMethods = signatureMethods;
	}

	public List<Annotation> getAnnotationClass() {
		return annotationClass;
	}

	public void setAnnotationClass(List<Annotation> annotationClass) {
		this.annotationClass = annotationClass;
	}


	public List<String> getSignatureStateVariablbe() {
		return signatureStateVariable;
	}


	public void setSignatureStateVariablbe(List<String> signatureStateVariablbe) {
		this.signatureStateVariable = signatureStateVariablbe;
	}


	public List<String> getSignatureImports() {
		return signatureImports;
	}


	public void setSignatureImports(List<String> signatureImports) {
		this.signatureImports = signatureImports;
	}

	public String getSignaturePackage() {
		return signaturePackage;
	}

	public void setSignaturePackage(String signaturePackage) {
		this.signaturePackage = signaturePackage;
	}

	private String findPackage(List<String> lines) {
		String signaturePAckage = null;
		for(String line: lines) {
			if(line.trim().startsWith("package")) {
				signaturePAckage = line.trim().substring(line.trim().indexOf("package") + "package".length(), line.trim().indexOf(";")).trim();
				break;
			}
		}
		return signaturePAckage;
	}

	private List<String> findAllImports(List<String> lines) {
		List<String> imports = new ArrayList<String>();
		for(String line: lines) {
			if(line.trim().startsWith("import")) {
				imports.add(line.trim().substring(line.trim().indexOf("import") + "import".length(), line.trim().indexOf(";")).trim());
			}
		}
		return imports;
	}

	private List<Annotation> findAllClassAnnotation(List<String> lines) {
		List<Annotation> annotations = new ArrayList<Annotation>();
		Annotation a = null;
		boolean find = false;
		for(String line: lines) {
			if(find == true && line.trim().length() > 0 && !line.trim().contains(" class ")) {
				// detect field
				String nameField = line.trim().substring(0, line.trim().indexOf("=")).trim();
				String valueField = line.trim().substring(line.trim().indexOf("=")+1, line.trim().length() - 1).trim();
				a.getFields().put(nameField, valueField);
			}
			if(line.trim().startsWith("@")) {
				if(a != null) {
					annotations.add(a);
				}
				a = new Annotation();

				// detect name
				String annotationName = line.substring(0, line.indexOf("(")).trim();
				a.setName(annotationName);

				find = true;
			}

			if(line.trim().contains(" class ")) {
				if(a != null) {
					annotations.add(a);
				}
				// detect class declaration
				break;
			}
		}
		return annotations;
	}

	private String findClassName(List<String> lines) {
		String className = "";
		for(String line: lines) {
			if(line.trim().contains(" class ")) {
				className = line.trim().substring(line.trim().indexOf(" class ") + " class ".length(), line.trim().indexOf(" implements ")).trim(); 
				break;
			}
		}
		return className;
	}

	private String findInterfaceName(List<String> lines) {
		String interfaceName = "";
		for(String line: lines) {
			if(line.trim().contains(" implements ")) {
				interfaceName = line.trim().substring(line.trim().indexOf(" implements ") + " implements ".length(), line.trim().indexOf("{")).trim(); 
				break;
			}
		}
		return interfaceName;
	}

	private List<String> findAllStateVariables(List<String> lines) {
		List<String> variables = new ArrayList<String>();
		for(String line: lines) {
			if(line.trim().startsWith("private") && line.trim().endsWith(";")) {
				variables.add(line.trim());
			}
		}
		return variables;
	}

	private List<Method> findAllMethods(List<String> lines, File classFile) throws WSOUIException {
		List<Method> methods = new ArrayList<Method>();
		boolean classDetected = false;
		for(String line: lines) {
			if(classDetected) {
				if(line.trim().startsWith("public")) {

					String deletePublic = line.trim().substring(line.trim().indexOf("public") + "public".length()).trim();
					String outputParamType = deletePublic.trim().substring(0, deletePublic.indexOf(" ")).trim();
					Parameter outputParameter = new Parameter();
					outputParameter.setType(outputParamType);
                                        
					String deleteOutputParam = deletePublic.trim().substring(deletePublic.indexOf(" ")).trim();
					boolean isConstructor = false;
					if(outputParamType.contains("(")) {
						isConstructor = true;
					}
					if(!isConstructor) {
						String methodName = deleteOutputParam.trim().substring(0, deleteOutputParam.trim().indexOf("(")).trim();
						List<String> inputParams = new ArrayList<String>();
						String deleteMethodName = deleteOutputParam.substring(deleteOutputParam.trim().indexOf("(")+1);
						String allInputParams = deleteMethodName.substring(0, deleteMethodName.indexOf(")"));
						StringTokenizer st = new StringTokenizer(allInputParams, ",");
						if(st.countTokens() == 0) {
							inputParams.add(allInputParams.trim());
						} else {
							while(st.hasMoreTokens()) {
								inputParams.add(st.nextToken().trim());
							}
						}
						List<Parameter> inputParameters = new ArrayList<Parameter>();
						for(String param: inputParams) {
							Parameter inputParameter = new Parameter();
							inputParameter.setType(param.split(" ")[0].trim());
							inputParameter.setName(param.split(" ")[1].trim());
							inputParameters.add(inputParameter);
						}
						if(inputParameters.size() > 1) {
							throw new WSOUIException("[CXF Restriction]: Your wsdl description must be document litteral wrapped to be sure that the code generation would be ok!!!");
						}

						List<String> exceptions = new ArrayList<String>();
						if(line.contains("throws"))  {
							String allExceptions = deleteMethodName.substring(deleteMethodName.indexOf("throws") + "throws".length(), deleteMethodName.indexOf("{"));
							st = new StringTokenizer(allExceptions, ",");
							if(st.countTokens() == 0) {
                                                            try {
                                                                Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "One Exception Thrown for "+methodName+" : "+allExceptions.trim());
//                                                                URL source = Thread.currentThread().getContextClassLoader().getResource(allExceptions.trim());
//                                                                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
//                                                                compiler.run(null, null, null,new File(source.toURI()).getPath());
//                                                                URLClassLoader cl = URLClassLoader.newInstance(new URL[]{source});
//                                                                Class c = Class.forName(allExceptions.trim(),true,  cl);//Thread.currentThread().getContextClassLoader().loadClass(allExceptions.trim());
//                                                                Exception ex =(Exception) c.newInstance();//(Exception) c.getConstructors()[0].newInstance(null);
                                                                String ex = allExceptions.trim();

                                                                for(String import_ : this.signatureImports){
                                                                    if(import_.contains(ex)){
                                                                        ex = import_;
                                                                        break;
                                                                    }
                                                                }
                                                                exceptions.add(ex);
                                                            } catch (Exception ex) {
                                                                Logger.getLogger(ImplMetaInf.class.getName()).log(Level.SEVERE, null, ex);
                                                            } 
							
							} else {
								while(st.hasMoreTokens()) {
                                                                     try {
                                                                         String token = st.nextToken().trim();
//                                                                         if(token.contains(".")){
//                                                                            token = token.substring(token.lastIndexOf(".")+1, token.length());
//                                                                         }
//
//                                                                          Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "Exception thrown for "+methodName+" : "+token);
//                                                                          Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "URLClassLoader ");
//                                                                          URLClassLoader cl = URLClassLoader.newInstance(new URL[]{classFile.getParentFile().toURI().toURL()});
//                                                                          Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "URLClassLoader "+classFile.getParentFile().toURI().toURL());
//                                                                          URL source = Thread.currentThread().getContextClassLoader().getResource(token);
//                                                                          if(source == null) {
//                                                                              Logger.getLogger(ImplMetaInf.class.getName()).log(Level.WARNING, "Exception class "+token+" not found ...");
//                                                                              continue;
//                                                                          }
//                                                                          JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
//                                                                          compiler.run(null, null, null,new File(source.toURI()).getPath());
//
//                                                                          Class c = Class.forName(allExceptions.trim(),true,  cl);//Thread.currentThread().getContextClassLoader().loadClass(allExceptions.trim());
//                                                                          Exception ex =(Exception) c.newInstance();//(Exception) c.getConstructors()[0].newInstance(null);

                                                                          for(String import_ : this.signatureImports){
                                                                            if(import_.contains(token)){
                                                                                token = import_;
                                                                                break;
                                                                             }
                                                                           }
                                                                         exceptions.add(token);
                                                                     } catch (Exception ex) {
                                                                            Logger.getLogger(ImplMetaInf.class.getName()).log(Level.SEVERE, null, ex);
                                                                     }
								}
							}
						}

						// set all method elements
						Method m = new Method();
						m.setName(methodName);

						m.setOutputParam(outputParameter);
						m.setInputParams(inputParameters);
						m.setExceptions(exceptions);
						methods.add(m);
					}
				}
			}
			if(line.trim().contains(" class ")) {
				classDetected = true;
			}
		}
		return methods;
	}

	public String getWsdlLocation() {
		return wsdlLocation.replace("\"", "");
	}

	public void setWsdlLocation(String wsdlLocation) {
		this.wsdlLocation = wsdlLocation;
	}

	public String getTargetNamespace() {
		return targetNamespace;
	}

	public void setTargetNamespace(String targetNamespace) {
		this.targetNamespace = targetNamespace;
	}

	private List<String> deleteAllComments(List<String> lines) {
		List<String> linesWithoutComments = new ArrayList<String>();
		for(String line: lines) {
			if(!line.trim().startsWith("*") && !line.trim().startsWith("/*")) {
				linesWithoutComments.add(line);
			}
		}
		return linesWithoutComments;
	}

	@Override
	public String toString() {
		return "ImplMetaInf [signaturePackage=" + signaturePackage
		+ ", signatureImports=" + signatureImports + ", className="
		+ className + ", interfaceName=" + interfaceName
		+ ", serviceName=" + serviceName + ", endpointName="
		+ endpointName + ", wsdlLocation=" + wsdlLocation
		+ ", signatureStateVariable=" + signatureStateVariable
		+ ", signatureMethods=" + signatureMethods
		+ ", annotationClass=" + annotationClass + ", conf=" + conf
		+ ", wsdl=" + wsdl + "]";
	}


}
