/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SDKGui.java
 *
 * Created on 31 janv. 2011, 15:20:50
 */
package org.petalslink.easiestdemo.sdk.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.sdk.SDKException;
import org.petalslink.easiestdemo.sdk.SDKService;
import org.petalslink.easiestdemo.sdk.util.JPanelImageBg;

/**
 *
 * @author nsalatge
 */
public class SDKGui extends javax.swing.JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final URL BACKGROUND_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/fond_ecran_sombre_800x600.png");
	private static final URL ICON_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/easylink-ico.png");
	private static final URL ICON_ARROW_BLUE_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/next-bleu-arrow.png");

	private static final URL ICON_CREATE_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/createProject.png");
	private static final URL ICON_COMPILE_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/compileProject.png");
	private static final URL ICON_RUN_PROJECT_IMAGE = Thread.currentThread().getContextClassLoader().getResource("images/runProject.png");


	private static final String DEFAULT_OUT_DIRECTORY = System.getProperty("user.home") + File.separator + "EasiestDemoProjects";

	private SDKService service = new SDKService();

	private QName bpelProcess = null;

	/** Creates new form SDKGui */
	public SDKGui() {
		this.setTitle("EasiestDemo SDK");
		this.setLocation();
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(ICON_IMAGE));

		ImageIcon imgIcon = new ImageIcon(BACKGROUND_IMAGE);
		Image backgroundImg = imgIcon.getImage().getScaledInstance(1024, 1024, java.awt.Image.SCALE_SMOOTH);  

		this.setContentPane(new JPanelImageBg(backgroundImg));
		initComponents();



		JTextAreaOutputStream outStream = new JTextAreaOutputStream(this.jTextAreaOutputTextArea); 
		JTextAreaOutputStream errStream = new JTextAreaOutputStream(this.jTextAreaOutputTextArea); 
		System.setOut(new PrintStream(outStream)); 
		System.setErr(new PrintStream(errStream));

		this.setBackground(Color.black);
		this.jPanelMain.setOpaque(false);
		this.jPanelActions.setOpaque(false);
		this.jPanelOutputConsole.setOpaque(false);
		this.jRadioButtonMavenProjectFromBpel.setOpaque(false);
		this.jRadioButtonNewMavenProject.setOpaque(false);

		this.jButtonCreateProject.setIcon(createImageIcon(this.jButtonCreateProject, ICON_CREATE_PROJECT_IMAGE));
		this.jButtonCompileProject.setIcon(createImageIcon(this.jButtonCompileProject, ICON_COMPILE_PROJECT_IMAGE));
		this.jButtonRunProject.setIcon(createImageIcon(this.jButtonRunProject, ICON_RUN_PROJECT_IMAGE));
		this.jLabelStep1ToStep2.setIcon(new ImageIcon(ICON_ARROW_BLUE_IMAGE));
		this.jLabelStep2ToStep3.setIcon(new ImageIcon(ICON_ARROW_BLUE_IMAGE));
		this.jButtonCreateProject.setText("");
		this.jButtonCompileProject.setText("");
		this.jButtonRunProject.setText("");
		this.jLabelStep1ToStep2.setText("");
		this.jLabelStep2ToStep3.setText("");

		this.jRadioButtonNewMavenProjectActionPerformed(null);
		disabledAll();

		this.jTextFieldOutputDirectory.setText(DEFAULT_OUT_DIRECTORY.toString());
		this.jTextFieldProject.setText("{http://wwww.petalslink.com}HelloWorldProcess");
		this.jTextFieldProjectKeyPressed(null);
	}


	private ImageIcon createImageIcon(JButton button, URL url) {
		ImageIcon icon = new ImageIcon(url);
		Image img = icon.getImage() ;  
		Image newImg = img.getScaledInstance(button.getWidth(), button.getHeight(), java.awt.Image.SCALE_SMOOTH);  
		icon = new ImageIcon(newImg);
		return icon;
	}


	private void disabledAll() {
		this.jButtonCreateProject.setEnabled(false);
		this.jButtonCompileProject.setEnabled(false);
		this.jButtonRunProject.setEnabled(false);
		this.jLabelStep1ToStep2.setEnabled(false);
		this.jLabelStep2ToStep3.setEnabled(false);
	}


	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/4, (int)heightScreen/4);
	}


	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">
	private void initComponents() {

		buttonGroupCreateMavenProject = new javax.swing.ButtonGroup();
		jPanelMain = new javax.swing.JPanel();
		jRadioButtonNewMavenProject = new javax.swing.JRadioButton();
		jRadioButtonMavenProjectFromBpel = new javax.swing.JRadioButton();
		jTextFieldProject = new javax.swing.JTextField();
		jButtonBrowseProject = new javax.swing.JButton();
		jLabelOutputDirectory = new javax.swing.JLabel();
		jTextFieldOutputDirectory = new javax.swing.JTextField();
		jButtonBrowseOutputDirectory = new javax.swing.JButton();
		jPanelOutputConsole = new javax.swing.JPanel();
		jScrollPaneOutputTextArea = new javax.swing.JScrollPane();
		jTextAreaOutputTextArea = new javax.swing.JTextArea();
		jPanelActions = new javax.swing.JPanel();
		jButtonCreateProject = new javax.swing.JButton();
		jButtonCompileProject = new javax.swing.JButton();
		jButtonRunProject = new javax.swing.JButton();
		jLabelStep1ToStep2 = new javax.swing.JLabel();
		jLabelStep2ToStep3 = new javax.swing.JLabel();
		jLabelBpelNameOrUrl = new javax.swing.JLabel();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		buttonGroupCreateMavenProject.add(jRadioButtonNewMavenProject);
		jRadioButtonNewMavenProject.setText("Create New Bpel Maven Project");
		jRadioButtonNewMavenProject.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jRadioButtonNewMavenProjectActionPerformed(evt);
			}
		});

		buttonGroupCreateMavenProject.add(jRadioButtonMavenProjectFromBpel);
		jRadioButtonMavenProjectFromBpel.setText("Create Bpel Maven Project from existing Bpel ");
		jRadioButtonMavenProjectFromBpel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jRadioButtonMavenProjectFromBpelActionPerformed(evt);
			}
		});


		jTextFieldProject.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(java.awt.event.KeyEvent evt) {
				jTextFieldProjectKeyPressed(evt);
			}
		});

		jButtonBrowseProject.setText("Parcourir...");
		jButtonBrowseProject.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonBrowseProjectActionPerformed(evt);
			}
		});

		jLabelOutputDirectory.setText("Output Directory:");


		jTextFieldOutputDirectory.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(java.awt.event.KeyEvent evt) {
				jTextFieldOutputDirectoryKeyPressed(evt);
			}
		});

		jButtonBrowseOutputDirectory.setText("Parcourir...");
		jButtonBrowseOutputDirectory.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonBrowseOutputDirectoryActionPerformed(evt);
			}
		});

		jPanelOutputConsole.setBorder(javax.swing.BorderFactory.createTitledBorder("Output Console"));

		jTextAreaOutputTextArea.setColumns(20);
		jTextAreaOutputTextArea.setRows(5);
		jScrollPaneOutputTextArea.setViewportView(jTextAreaOutputTextArea);

		javax.swing.GroupLayout jPanelOutputConsoleLayout = new javax.swing.GroupLayout(jPanelOutputConsole);
		jPanelOutputConsole.setLayout(jPanelOutputConsoleLayout);
		jPanelOutputConsoleLayout.setHorizontalGroup(
				jPanelOutputConsoleLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelOutputConsoleLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneOutputTextArea, javax.swing.GroupLayout.DEFAULT_SIZE, 707, Short.MAX_VALUE)
						.addContainerGap())
		);
		jPanelOutputConsoleLayout.setVerticalGroup(
				jPanelOutputConsoleLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelOutputConsoleLayout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jScrollPaneOutputTextArea, javax.swing.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE)
						.addContainerGap())
		);

		jPanelActions.setBorder(javax.swing.BorderFactory.createTitledBorder("Actions"));

		jButtonCreateProject.setText("Create Project");
		jButtonCreateProject.setMaximumSize(new java.awt.Dimension(107, 23));
		jButtonCreateProject.setMinimumSize(new java.awt.Dimension(107, 23));
		jButtonCreateProject.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonCreateProjectActionPerformed(evt);
			}
		});

		jButtonCompileProject.setText("Compile Project");
		jButtonCompileProject.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonCompileProjectActionPerformed(evt);
			}
		});

		jButtonRunProject.setText("Run Project");
		jButtonRunProject.setMaximumSize(new java.awt.Dimension(107, 23));
		jButtonRunProject.setMinimumSize(new java.awt.Dimension(107, 23));
		jButtonRunProject.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonRunProjectActionPerformed(evt);
			}
		});

		jLabelStep1ToStep2.setText(".... -> ....");

		jLabelStep2ToStep3.setText(".... -> ....");

		javax.swing.GroupLayout jPanelActionsLayout = new javax.swing.GroupLayout(jPanelActions);
		jPanelActions.setLayout(jPanelActionsLayout);
		jPanelActionsLayout.setHorizontalGroup(
				jPanelActionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelActionsLayout.createSequentialGroup()
						.addGap(142, 142, 142)
						.addComponent(jButtonCreateProject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
						.addComponent(jLabelStep1ToStep2)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addComponent(jButtonCompileProject)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
						.addComponent(jLabelStep2ToStep3)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addComponent(jButtonRunProject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(158, Short.MAX_VALUE))
		);
		jPanelActionsLayout.setVerticalGroup(
				jPanelActionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup()
						.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGroup(jPanelActionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addGroup(jPanelActionsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
										.addComponent(jButtonRunProject, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addComponent(jButtonCompileProject, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addComponent(jButtonCreateProject, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))
										.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup()
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
												.addComponent(jLabelStep1ToStep2)
												.addGap(39, 39, 39))
												.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelActionsLayout.createSequentialGroup()
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(jLabelStep2ToStep3)
														.addGap(37, 37, 37)))
														.addContainerGap())
		);

		jLabelBpelNameOrUrl.setText("Bpel QName [{tns}name] :");

		javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
		jPanelMain.setLayout(jPanelMainLayout);
		jPanelMainLayout.setHorizontalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelMainLayout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jRadioButtonMavenProjectFromBpel, javax.swing.GroupLayout.DEFAULT_SIZE, 893, Short.MAX_VALUE)
								.addComponent(jRadioButtonNewMavenProject, javax.swing.GroupLayout.DEFAULT_SIZE, 893, Short.MAX_VALUE)
								.addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
										.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
												.addComponent(jLabelBpelNameOrUrl)
												.addComponent(jLabelOutputDirectory))
												.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
												.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
														.addComponent(jTextFieldProject)
														.addComponent(jTextFieldOutputDirectory, javax.swing.GroupLayout.PREFERRED_SIZE, 357, javax.swing.GroupLayout.PREFERRED_SIZE))
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
														.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
																.addComponent(jButtonBrowseProject, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																.addComponent(jButtonBrowseOutputDirectory, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 312, Short.MAX_VALUE))
																.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
																		.addComponent(jPanelOutputConsole, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																		.addComponent(jPanelActions, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
																		.addContainerGap())
		);
		jPanelMainLayout.setVerticalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanelMainLayout.createSequentialGroup()
						.addGap(30, 30, 30)
						.addComponent(jRadioButtonNewMavenProject)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
						.addComponent(jRadioButtonMavenProjectFromBpel)
						.addGap(18, 18, 18)
						.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jLabelBpelNameOrUrl)
								.addGroup(jPanelMainLayout.createSequentialGroup()
										.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
												.addComponent(jTextFieldProject, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
												.addComponent(jButtonBrowseProject))
												.addGap(18, 18, 18)
												.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
														.addComponent(jTextFieldOutputDirectory, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
														.addComponent(jButtonBrowseOutputDirectory)
														.addComponent(jLabelOutputDirectory))))
														.addGap(26, 26, 26)
														.addComponent(jPanelActions, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
														.addGap(18, 18, 18)
														.addComponent(jPanelOutputConsole, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
														.addContainerGap())
		);

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addContainerGap(20, Short.MAX_VALUE))
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
		);

		pack();
	}// </editor-fold>

	private void jRadioButtonNewMavenProjectActionPerformed(java.awt.event.ActionEvent evt) {                                                            
		this.jRadioButtonNewMavenProject.setSelected(true);
		this.jLabelBpelNameOrUrl.setText("Bpel QName : ");
		this.jButtonBrowseProject.setVisible(false);
		this.jTextFieldProject.setText("");
		this.jTextFieldProjectKeyPressed(null);
	}                                                           

	private void jRadioButtonMavenProjectFromBpelActionPerformed(java.awt.event.ActionEvent evt) {                                                                 
		this.jRadioButtonMavenProjectFromBpel.setSelected(true);
		this.jLabelBpelNameOrUrl.setText("Bpel URL : ");
		this.jButtonBrowseProject.setVisible(true);
		this.jTextFieldProject.setText("");
		this.jTextFieldProjectKeyPressed(null);
	}                                                                

	private void jButtonBrowseProjectActionPerformed(java.awt.event.ActionEvent evt) {                                                     
		JFileChooser c = new JFileChooser();
		c.addChoosableFileFilter(new BPELFilter());
		c.setAcceptAllFileFilterUsed(false);


		// Demonstrate "Open" dialog:
		int rVal = c.showOpenDialog(this);
		if (rVal == JFileChooser.APPROVE_OPTION) {
			jTextFieldProject.setText(c.getSelectedFile().getAbsolutePath());
			jTextFieldProjectKeyPressed(null);
		}
		if (rVal == JFileChooser.CANCEL_OPTION) {
			jTextFieldProject.setText("");
		}
	}                                                    

	private void jButtonBrowseOutputDirectoryActionPerformed(java.awt.event.ActionEvent evt) {                                                             
		JFileChooser c = new JFileChooser();
		c.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

		// Demonstrate "Open" dialog:
		int rVal = c.showOpenDialog(this);
		if (rVal == JFileChooser.APPROVE_OPTION) {
			jTextFieldOutputDirectory.setText(c.getSelectedFile().getAbsolutePath());
			jTextFieldOutputDirectoryKeyPressed(null);
		}
		if (rVal == JFileChooser.CANCEL_OPTION) {
			jTextFieldOutputDirectory.setText("");
		}
	}                                                            

	private void jButtonCreateProjectActionPerformed(java.awt.event.ActionEvent evt) {
		try {
			boolean generateFile = false;
			if(this.jRadioButtonNewMavenProject.isSelected()) {
				generateFile = true;
			} else {
				generateFile = false;
			}
			this.paint(this.getGraphics());
			if(generateFile == true) {
				bpelProcess = QName.valueOf(this.jTextFieldProject.getText());
				bpelProcess = this.service.createNewProject(bpelProcess.getNamespaceURI(), bpelProcess.getLocalPart(), new File(this.jTextFieldOutputDirectory.getText()), true);
			} else {
				bpelProcess = this.service.createProjectFromBpel(new File(this.jTextFieldProject.getText()).toURI().toURL(), new File(this.jTextFieldOutputDirectory.getText()));
			}
			if(bpelProcess != null) {

				// result
				int res = this.service.importProjectIntoEclipse(new File(this.jTextFieldOutputDirectory.getText() + "/" + bpelProcess.getLocalPart().toLowerCase()), null);
				if(res == 0) {
					String msg = "Bpel project create at: " + this.jTextFieldOutputDirectory.getText() + "/" + bpelProcess.getLocalPart().toLowerCase() +
					"\nYou can now open your project in eclipse IDE: Click on File->Import->General->Import existing project in your workspace";
					System.out.println(msg);
					JOptionPane.showMessageDialog(this,
							msg, 
							"Creation Succesfull", JOptionPane.INFORMATION_MESSAGE);

					this.jLabelStep1ToStep2.setEnabled(true);
					this.jButtonCompileProject.setEnabled(true);
					
				} else {
					String msg = "Impossible to import project, sorry!!!";
					System.out.println(msg);
					JOptionPane.showMessageDialog(this,
							msg, 
							"Creation Interrupted", JOptionPane.ERROR_MESSAGE);
				}
			} else {
				String msg = "Impossible to create project, sorry!!!";
				System.out.println(msg);
				JOptionPane.showMessageDialog(this,
						msg, 
						"Creation Interrupted", JOptionPane.ERROR_MESSAGE);
			}

		} catch (SDKException e) {
			e.printStackTrace(System.out);
		} catch (MalformedURLException e) {
			e.printStackTrace(System.out);
		}

	}                                                    

	private void jButtonCompileProjectActionPerformed(java.awt.event.ActionEvent evt) {                                                      
		try {
			int res = this.service.compileProject(new File(this.jTextFieldOutputDirectory.getText() + "/" + bpelProcess.getLocalPart().toLowerCase()), null);
			if(res == 0) {
				String msg = "Bpel compiled. You can now run it!!!";
				System.out.println(msg);
				JOptionPane.showMessageDialog(this,
						msg, 
						"Creation Succesfull", JOptionPane.INFORMATION_MESSAGE);

				this.jLabelStep2ToStep3.setEnabled(true);
				this.jButtonRunProject.setEnabled(true);
				
			} else {
				String msg = "Impossible to compile project, sorry!!!";
				System.out.println(msg);
				JOptionPane.showMessageDialog(this,
						msg, 
						"Compilation Interrupted", JOptionPane.ERROR_MESSAGE);
			}
		
		} catch (SDKException e) {
			System.out.println(e.getMessage());
		}

		
	}                                                     


	private void jButtonRunProjectActionPerformed(java.awt.event.ActionEvent evt) {                                                  
		try {
			this.service.runProject(new File(this.jTextFieldOutputDirectory.getText() + "/" + bpelProcess.getLocalPart().toLowerCase()), null);
		} catch (SDKException e) {
			System.out.println(e.getMessage());
		}
	}                                              

	private void jTextFieldOutputDirectoryKeyPressed(java.awt.event.KeyEvent evt) {
		if(this.jTextFieldProject.getText() != null &&
				this.jTextFieldProject.getText().trim().length() > 0 &&
				this.jTextFieldOutputDirectory.getText() != null &&
				this.jTextFieldOutputDirectory.getText().trim().length() > 0) {
			this.jButtonCreateProject.setEnabled(true);
		} else {
			this.disabledAll();
		}
	}

	private void jTextFieldProjectKeyPressed(java.awt.event.KeyEvent evt) {
		if(this.jTextFieldProject.getText() != null &&
				this.jTextFieldProject.getText().trim().length() > 0 &&
				this.jTextFieldOutputDirectory.getText() != null &&
				this.jTextFieldOutputDirectory.getText().trim().length() > 0) {
			this.jButtonCreateProject.setEnabled(true);
		} else {
			this.disabledAll();
		}
	}


	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new SDKGui().setVisible(true);
			}
		});
	}

	// Variables declaration - do not modify
	private javax.swing.ButtonGroup buttonGroupCreateMavenProject;
	private javax.swing.JButton jButtonBrowseOutputDirectory;
	private javax.swing.JButton jButtonBrowseProject;
	private javax.swing.JButton jButtonCompileProject;
	private javax.swing.JButton jButtonCreateProject;
	private javax.swing.JButton jButtonRunProject;
	private javax.swing.JLabel jLabelBpelNameOrUrl;
	private javax.swing.JLabel jLabelOutputDirectory;
	private javax.swing.JLabel jLabelStep1ToStep2;
	private javax.swing.JLabel jLabelStep2ToStep3;
	private javax.swing.JPanel jPanelActions;
	private javax.swing.JPanel jPanelMain;
	private javax.swing.JPanel jPanelOutputConsole;
	private javax.swing.JRadioButton jRadioButtonMavenProjectFromBpel;
	private javax.swing.JRadioButton jRadioButtonNewMavenProject;
	private javax.swing.JScrollPane jScrollPaneOutputTextArea;
	private javax.swing.JTextArea jTextAreaOutputTextArea;
	private javax.swing.JTextField jTextFieldOutputDirectory;
	private javax.swing.JTextField jTextFieldProject;
	// End of variables declaration
}
