package org.petalslink.easiestdemo.sdk.util;

import javax.swing.*; 
import java.awt.*; 
import java.awt.geom.AffineTransform;
import java.awt.image.*; 
import java.net.URL;

public class JPanelImageBg extends JComponent
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private int mode;
	private TexturePaint texture; 
	private BufferedImage bufferedImage; 

	public static final int CENTRE = 0;
	public static final int TEXTURE = 1;

	public JPanelImageBg( URL fileName, int mode )
	{	this.mode = mode;
		this.bufferedImage = this.toBufferedImage(Toolkit.getDefaultToolkit().getImage(fileName));
		this.texture = new TexturePaint(bufferedImage,new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight())); 
	} 
	
	public JPanelImageBg( Image img )
	{	this.mode = CENTRE;
		this.bufferedImage = this.toBufferedImage(img);
		this.texture = new TexturePaint(bufferedImage,new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight())); 
	} 

	public void paintComponent(Graphics g)
	{	switch( mode )
		{	case TEXTURE :
				Graphics2D g2d = (Graphics2D)g; 
				g2d.setPaint(texture);
				g2d.fillRect(0, 0, getWidth(), getHeight() );
				break;
			case CENTRE :
				g.setColor(this.getBackground());
				g.fillRect(0,0,getWidth(), getHeight() );
				g.drawImage(bufferedImage,(getWidth()-bufferedImage.getWidth())/2,(getHeight()-bufferedImage.getHeight())/2,null);
				break;
			default :
				super.paintComponents(g);
		}
	}


	private BufferedImage toBufferedImage(Image image)
	{	image = new ImageIcon(image).getImage(); 

		BufferedImage bufferedImage = new BufferedImage( image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB); 
		Graphics g = bufferedImage.createGraphics(); 

		g.setColor(Color.white); 
		g.fillRect(0, 0, image.getWidth(null), 
		image.getHeight(null)); 
		g.drawImage(image, 0, 0, null); 
		g.dispose(); 
		return bufferedImage; 
	}


	public static BufferedImage scale(BufferedImage bi, double scaleValue) {
	        AffineTransform tx = new AffineTransform();
	        tx.scale(scaleValue, scaleValue);
	        AffineTransformOp op = new AffineTransformOp(tx,
	                AffineTransformOp.TYPE_BILINEAR);
	        BufferedImage biNew = new BufferedImage( (int) (bi.getWidth() * scaleValue),
	                (int) (bi.getHeight() * scaleValue),
	                bi.getType());
	        return op.filter(bi, biNew);
	                
	} 
	

	public static Image scale(Image source, int width, int height) {
	    BufferedImage buf = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);

	    Graphics2D g = buf.createGraphics();
	    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
	    g.drawImage(source, 0, 0, width, height, null);
	    g.dispose();

	    return buf;
	}

}

