/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyvprop20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property;

import easybox.org.oasis_open.docs.wsbpel._2_0.varprop.EJaxbProperty;

final class PropertyImpl extends AbstractTExtensibleElementsImpl<EJaxbProperty> implements Property {

    protected PropertyImpl(XmlContext xmlContext, EJaxbProperty jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
        
    }

    @Override
    public boolean hasType() {
        return getModelObject().isSetType();
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
        
    }

    @Override
    public boolean hasElement() {
        return getModelObject().isSetElement();
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName element) {
        getModelObject().setElement(element);
    }

    @Override
    protected Class<? extends EJaxbProperty> getCompliantModelClass() {
        return EJaxbProperty.class;
    }

}
