/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.ContainersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.SourcesImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.TargetsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;




/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractActivityImpl<E extends TActivity> extends ContainersImpl<E> implements Activity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AbstractActivityImpl.class.getName());

	protected Sources sources = null;

	protected Targets targets = null;

	@SuppressWarnings("unchecked")
	public AbstractActivityImpl(final QName name, final E model, final BPELElement parent) {
		super(name, model, parent);
		if(model != null) {
			if(this.model.getSources() != null) {
				this.sources = new SourcesImpl(this.model.getSources(), this);
			}
			if(this.model.getTargets() != null) {
				this.targets = new TargetsImpl(this.model.getTargets(), this);
			}
		}
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implemented");
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(final String name) {
		this.model.setName(name);
	}

	public Sources getSources() {
		return this.sources;
	}
	
	public void setSources(Sources s){
		this.sources = s;
	}

	public boolean getSuppressJoinFailure() {
		return Boolean.valueOf(this.model.getSuppressJoinFailure().value);
	}
	
	public void setSuppressJoinFailure(boolean b){
		TBoolean res;
		if(b){
			res = TBoolean.YES;
		}else{
			res= TBoolean.NO;
		}
		this.model.setSuppressJoinFailure(res);
	}

	public Targets getTargets() {
		return this.targets;
	}
	
	public void setTargets(Targets t){
		this.targets = t;
	}

}
