/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension;

import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

public interface ExtendedActivity {

	QName getTag();
	
	void setTag(QName name);
	
	String getName();

	void setName(String name);

	boolean getSuppressJoinFailure();

	Sources getSources();

	Targets getTargets();

	void setSources(Sources src);

	void setTargets(Targets trg);

	void validate(BPELStaticAnalysis analyzer);

	Node generate(Scope scope) throws CoreException;
	
}
