/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api.activity;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface Invoke extends Activity {

	String  getPartnerLink();
	
	void setPartnerLink(String partner);
	
	QName getInterface();
	
	void setInterface(QName interfaceQName);
	
	String getInputVariable();
	
	void setInputVariable(String input);
	
	String getOutputVariable();
	
	void setOutputVariable(String output);
	
	String getOperation();
	
	void setOperation(String operation);
	
	List<Correlation> getCorrelations();
	
	List<Catch> getCatchs();
	
	CatchAll getCatchAll();
}
