/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api;

import javax.xml.namespace.QName;



/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class Constants {

	/**
	 * BPEL 2.0 EXECUTABLE Namespace
	 */
	public static final String BPEL_20_EXECUTABLE_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

	/**
	 * BPEL 2.0 SERVICEREF Namespace
	 */
	public static final String BPEL_20_SERVICEREF_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/serviceref";

	/**
	 * BPEL 2.0 ABSTRACT Namespace
	 */
	public static final String BPEL_20_ABSTRACT_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/process/abstract";

	/**
	 * BPEL 2.0 PARTNERLINK Namespace
	 */
	public static final String BPEL_20_PARTNERLINK_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";

	/**
	 * BPEL 2.0 VARPROP Namespace
	 */
	public static final String BPEL_20_VARPROP_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/varprop";

	/**
	 * BPEL 2.0 Process root tag
	 */
	public static final String PROCESS_ROOT_TAG = "process";

	/**
	 * Supported xpath functions
	 */
	public static final String XPATH_FUNCTIONS_NAMESPACE = "http://www.w3.org/2005/xpath-functions";

	
	/**
	 * eBM extension Activity
	 */
	public static final String BPEL_20_EBM_EXT_PROP_NAMESPACE = "http://com.ebmwebsourcing/ExtensionActivities";

	

	/**
	 * BPEL tag
	 */
	public final static QName _Documentation_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "documentation", "bpws");
	public final static QName _CorrelationSets_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "correlationSets", "bpws");
	public final static QName _JoinCondition_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "joinCondition", "bpws");
	public final static QName _MessageExchanges_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "messageExchanges", "bpws");
	public final static QName _Extension_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "extension", "bpws");
	public final static QName _PartnerLink_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "partnerLink", "bpws");
	public final static QName _Target_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "target", "bpws");
	public final static QName _Process_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "process", "bpws");
	public final static QName _CatchAll_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "catchAll", "bpws");
	public final static QName _From_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "from", "bpws");
	public final static QName _FinalCounterValue_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "finalCounterValue", "bpws");
	public final static QName _Import_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "import", "bpws");
	public final static QName _PartnerLinks_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "partnerLinks", "bpws");
	public final static QName _Invoke_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "invoke", "bpws");
	public final static QName _Query_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "query", "bpws");
	public final static QName _If_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "if", "bpws");
	public final static QName _ForEach_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "forEach", "bpws");
	public final static QName _For_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "for", "bpws");
	public final static QName _Exit_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "exit", "bpws");
	public final static QName _EventHandlers_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "eventHandlers", "bpws");
	public final static QName _Until_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "until", "bpws");
	public final static QName _RepeatUntil_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "repeatUntil", "bpws");
	public final static QName _CompensationHandler_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "compensationHandler", "bpws");
	public final static QName _Catch_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "catch", "bpws");
	public final static QName _Sequence_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "sequence", "bpws");
	public final static QName _FaultHandlers_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "faultHandlers", "bpws");
	public final static QName _RepeatEvery_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "repeatEvery", "bpws");
	public final static QName _StartCounterValue_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "startCounterValue", "bpws");
	public final static QName _Receive_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "receive", "bpws");
	public final static QName _Flow_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "flow", "bpws");
	public final static QName _Wait_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "wait", "bpws");
	public final static QName _Links_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "links", "bpws");
	public final static QName _Copy_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "copy", "bpws");
	public final static QName _OnMessage_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "onMessage", "bpws");
	public final static QName _OnAlarm_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "onAlarm", "bpws");
	public final static QName _TransitionCondition_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "transitionCondition", "bpws");
	public final static QName _Extensions_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "extensions", "bpws");
	public final static QName _Reply_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "reply", "bpws");
	public final static QName _Validate_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "validate", "bpws");
	public final static QName _Compensate_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "compensate", "bpws");
	public final static QName _Pick_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "pick", "bpws");
	public final static QName _Literal_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "literal", "bpws");
	public final static QName _ToPart_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "toPart", "bpws");
	public final static QName _FromPart_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "fromPart", "bpws");
	public final static QName _Source_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "source", "bpws");
	public final static QName _Targets_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "targets", "bpws");
	public final static QName _Else_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "else", "bpws");
	public final static QName _Sources_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "sources", "bpws");
	public final static QName _Rethrow_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "rethrow", "bpws");
	public final static QName _CompletionCondition_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "completionCondition", "bpws");
	public final static QName _To_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "to", "bpws");
	public final static QName _Condition_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "condition", "bpws");
	public final static QName _Empty_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "empty", "bpws");
	public final static QName _ExtensionActivity_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "extensionActivity", "bpws");
	public final static QName _While_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "while", "bpws");
	public final static QName _ToParts_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "toParts", "bpws");
	public final static QName _Elseif_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "elseif", "bpws");
	public final static QName _Assign_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "assign", "bpws");
	public final static QName _CompensateScope_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "compensateScope", "bpws");
	public final static QName _Throw_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "throw", "bpws");
	public final static QName _CorrelationSet_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "correlationSet", "bpws");
	public final static QName _OnEvent_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "onEvent", "bpws");
	public final static QName _ExtensionAssignOperation_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "extensionAssignOperation", "bpws");
	public final static QName _Variables_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "variables", "bpws");
	public final static QName _FromParts_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "fromParts", "bpws");
	public final static QName _Branches_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "branches", "bpws");
	public final static QName _Link_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "link", "bpws");
	public final static QName _TerminationHandler_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "terminationHandler", "bpws");
	public final static QName _MessageExchange_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "messageExchange", "bpws");
	public final static QName _Variable_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "variable", "bpws");
	public final static QName _Scope_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "scope", "bpws");

	// added tags
	public final static QName _Correlation_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "correlation", "bpws");
	

	/**
	 * Service Ref tag
	 */
	public final static QName _ServiceRef_QNAME = new QName("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref", "sref");
}
