/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.WSDLVersionConstants;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;
import org.petalslink.abslayer.service.api.Service;

public class Descriptions {
    private static XmlContext xmlContext;
    String processNamespace;
    List<Import> imports = new ArrayList<Import>();
    List<Description> descriptions = new ArrayList<Description>();
    List<Schema> schemas = new ArrayList<Schema>();

    public Descriptions(String processNamespace, String processItfName, List<Import> imports) {
        this.processNamespace = processNamespace;
        this.imports = imports;
        for (Import impt : this.imports) {
            if (impt.getDescription() != null) {
                this.descriptions.add(impt.getDescription());
                continue;
            }
            if (impt.getSchema2() == null) continue;
            this.schemas.add(impt.getSchema2());
        }
    }

    public void addImport(Import impt) {
        this.imports.add(impt);
        if (impt.getDescription() != null) {
            this.descriptions.add(impt.getDescription());
        } else if (impt.getSchema2() != null) {
            this.schemas.add(impt.getSchema2());
        }
    }

    public void removeImport(Import impt) {
        this.imports.remove(impt);
        if (impt.getDescription() != null) {
            this.descriptions.remove(impt.getDescription());
        } else if (impt.getSchema2() != null) {
            this.schemas.remove(impt.getSchema2());
        }
    }

    public final String getProcessNamespace() {
        return this.processNamespace;
    }

    public static Description readDescription11(URL location) throws XmlObjectReadException {
        XmlObjectReader reader = xmlContext.createReader();
        return (Description)Factory.getInstance().wrap(reader.readDocument(location, Definitions.class));
    }

    public static Description readDescription20(URL location) {
        throw new UnsupportedOperationException();
    }

    public static Schema readSchema(URL location) throws SchemaException {
        XmlObjectReader reader = xmlContext.createReader();
        try {
            return (Schema)reader.readDocument(location, Schema.class);
        }
        catch (XmlObjectReadException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public List<Import> getBPELImports() {
        return this.imports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSchema(Schema schema) {
        List<Schema> list = this.schemas;
        synchronized (list) {
            this.schemas.add(schema);
        }
    }

    public PartnerLinkType getPartnerLinkType(QName plt) {
        for (Description desc : this.descriptions) {
            PartnerLinkType partnerLinkType = desc.getPartnerLinkType(plt);
            if (partnerLinkType == null) continue;
            return partnerLinkType;
        }
        return null;
    }

    public Collection<Description> getDescriptions() {
        return Collections.unmodifiableCollection(this.descriptions);
    }

    public Description getDescriptionByService(QName service) {
        for (Description desc : this.descriptions) {
            if (desc.findInterface(service) == null) continue;
            return desc;
        }
        return null;
    }

    public Description getDescriptionByInterface(QName itf) {
        for (Description desc : this.descriptions) {
            if (desc.findInterface(itf) == null) continue;
            return desc;
        }
        return null;
    }

    public Description getDescriptionByProperty(QName propertyName) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> findElementsInAllSchema(QName element) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Description desc : this.descriptions) {
            elements.addAll(desc.findElementsInAllSchema(element));
        }
        List<Schema> list = this.schemas;
        synchronized (list) {
            for (Schema schema : this.schemas) {
                Element e = SchemaHelper.findElementByQName((XmlObject)schema, (QName)element);
                if (e == null) continue;
                elements.add(e);
            }
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> findTypesInAllSchema(QName type) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Description desc : this.descriptions) {
            Type t = SchemaHelper.findTypeByQName((XmlObject)desc.getModel(), (QName)type);
            if (t == null) continue;
            types.add(t);
        }
        List<Schema> list = this.schemas;
        synchronized (list) {
            for (Schema schema : this.schemas) {
                Type t = SchemaHelper.findTypeByQName((XmlObject)schema, (QName)type);
                if (t == null) continue;
                types.add(t);
            }
        }
        return types;
    }

    public Endpoint findEndpoint(String endpointName) {
        for (Description desc : this.descriptions) {
            Endpoint endpoint = desc.findEndpoint(endpointName);
            if (endpoint == null) continue;
            return endpoint;
        }
        return null;
    }

    public Interface findInterface(QName qname) {
        Interface itf = null;
        for (Description desc : this.descriptions) {
            itf = desc.findInterface(qname);
            if (itf == null) continue;
            return itf;
        }
        return null;
    }

    public Collection<Endpoint> findEndpointsImplementingInterface(Interface itf) {
        assert (itf != null);
        HashSet<Endpoint> endpoints = new HashSet<Endpoint>();
        for (Description desc : this.descriptions) {
            assert (desc != null);
            endpoints.addAll(desc.findEndpointsImplementingInterface(itf));
        }
        return endpoints;
    }

    public Property getProperty(QName qname) {
        for (Description desc : this.descriptions) {
            Property property = desc.findProperty(qname);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public List<PropertyAlias> getPropertyAliases() {
        ArrayList<PropertyAlias> propertyAliases = new ArrayList<PropertyAlias>();
        for (Description desc : this.descriptions) {
            propertyAliases.addAll(desc.getPropertyAliases());
        }
        return propertyAliases;
    }

    public List<PropertyAlias> getPropertyAliases4ThisProperty(QName propName) {
        ArrayList<PropertyAlias> propertyAliases = new ArrayList<PropertyAlias>();
        for (Description desc : this.descriptions) {
            propertyAliases.addAll(desc.getPropertyAliases4ThisProperty(propName));
        }
        return propertyAliases;
    }

    public Service findService(QName qname) {
        for (Description desc : this.descriptions) {
            Service s = desc.findService(qname);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public NamespaceMapperImpl getNamespaces() {
        throw new UnsupportedOperationException();
    }

    public Message findMessage(QName qname) {
        Message message = null;
        for (Description desc : this.descriptions) {
            message = desc.findMessage(qname);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public BindingOperation findBindingOperation(QName qname) {
        BindingOperation bindingOperation = null;
        for (Description desc : this.descriptions) {
            bindingOperation = desc.findBindingOperation(qname);
            if (bindingOperation == null) continue;
            return bindingOperation;
        }
        return null;
    }

    public WSDLVersionConstants getVersion() {
        throw new UnsupportedOperationException();
    }

    public List<Binding> getBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Description desc : this.descriptions) {
            bindings.addAll(desc.getBindings());
        }
        return bindings;
    }

    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Description desc : this.descriptions) {
            services.addAll(desc.getServices());
        }
        return services;
    }

    public static void setXmlContext(XmlContext xmlContext) {
        Descriptions.xmlContext = xmlContext;
    }

    static {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        xmlContext = xmlContextFactory.newContext();
    }
}

