/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension;

import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

public interface ExtendedActivity {

	QName getTag();
	
	void setTag(QName name);
	
	String getName();

	void setName(String name);

	boolean getSuppressJoinFailure();

	Sources getSources();

	Targets getTargets();

	void setSources(Sources src);

	void setTargets(Targets trg);

	void validate(BPELStaticAnalysis analyzer);

	Node generate(Scope scope) throws CoreException;
	
}
