/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDeadlineExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDeadLineExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDeadLineExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDurationExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WaitImpl extends ActivityImpl<TWait> implements Wait {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private BPELDurationExpression duration;
	
	private BPELDeadLineExpression date;

	public WaitImpl(final TWait model, final BPELElement parent) {
		super(Constants._Wait_QNAME, model, parent);
		
		if(this.model.getFor() != null) {
			this.duration = new BPELDurationExpressionImpl(this.model.getFor(), this);
		}
		
		if(this.model.getUntil() != null) {
			this.date = new BPELDeadLineExpressionImpl(this.model.getUntil(), this);
		}
	}


	public BPELDurationExpression getFor() {
		return this.duration;
	}


	public BPELDeadLineExpression getUntil() {
		return this.date;
	}
	
	public void setUntil(BPELDeadLineExpression deadLine){
		this.model.setUntil((TDeadlineExpr) ((AbstractSchemaElementImpl<?>)deadLine).getModel() );
	}
	
	public void setFor(BPELDurationExpression duration){
		this.model.setFor((TDurationExpr) ((AbstractSchemaElementImpl<?>)duration).getModel() );
	}

}
