/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink,
 * http://www.petalslink.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.registry.BPELRegistry;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = BPELRegistry.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class BPELMemoryRegistryImpl extends
        AbstractProcessDefinitionRegistry<BPELProcess> implements BPELRegistry {

    /**
	 *
	 */
    private static final long serialVersionUID = 1L;

    private Logger log = Logger.getLogger(BPELMemoryRegistryImpl.class
            .getName());

    public BPELProcess getProcessDefinition(final ProcessKey name) {
        return (BPELProcess) this.registry.get(name);
    }

    public List<BPELProcess> getAllProcessDefinitions() {
        // TODO : same definition is stored with different keys ; it corresponds
        // to number of interfaces used in this BPEL.
        return new ArrayList<BPELProcess>((Collection<BPELProcess>) this.registry.values());
    }

    public BPELProcess removeProcessDefinition(final ProcessKey name,
            final boolean forceUninstall) throws CoreException {
        BPELProcess res = null;
        this.log.finest("Map of instance: "
                + ((MemoryProcessInstanceRegistryImpl) this.getModel()
                        .getCore().getEngine().getProcessInstanceRegistry())
                        .getMap());

        // Delete all instances if they are in state ended
        Iterator<Process> it = this.getModel().getCore().getEngine()
                .getProcessInstanceRegistry().getProcessInstances(name)
                .iterator();
        final List<Process> undeleteProcess = new ArrayList<Process>();
        while (it.hasNext()) {
            final Process process = it.next();
            if (forceUninstall) {
                this.log.finest("remove process instance: " + process.getName());
                final Process p = this.getModel().getCore().getEngine()
                        .getProcessInstanceRegistry()
                        .removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine()
                            .getProcessInstanceRegistry()
                            .getProcessInstances(name).iterator();
                } else {
                    this.log.warning("Impossible to delete instance: process is null: "
                            + process.getName());
                }
            } else if (((process.getParentExecution() != null) && (process
                    .getParentExecution().getState() == Execution.State.ENDED))
                    || (process.getParentExecution() == null)) {
                this.log.finest("remove process instance: " + process.getName());

                final Process p = this.getModel().getCore().getEngine()
                        .getProcessInstanceRegistry()
                        .removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine()
                            .getProcessInstanceRegistry()
                            .getProcessInstances(name).iterator();
                } else {
                    this.log.warning("Impossible to delete instance, try forceuninstall=true: "
                            + process.getName());
                }
            } else {
                if (!undeleteProcess.contains(process)) {
                    undeleteProcess.add(process);
                }
            }
        }

        if (undeleteProcess.size() > 0) {
            // impossible to delete all instance: so, create message and throw
            // corresponding exception
            String errorMsg = "";
            for (final Process process : undeleteProcess) {
                errorMsg = errorMsg
                        + "Impossible to remove this process instance"
                        + process.getName()
                        + " because it is not ended: state = "
                        + process.getParentExecution().getState() + "\n";
            }
            throw new CoreException(errorMsg);
        } else {
            // Delete the definition
            res = (BPELProcess) this.registry.remove(name);
        }
        return res;
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }

    public List<ProcessKey> createKeys(ProcessDefinition processDefinition)
            throws CoreException {
        BPELProcess bpelDefinition = (BPELProcess) processDefinition;
        final List<ProcessKey> keys = new ArrayList<ProcessKey>();
        List<Interface> itfs;
        itfs = bpelDefinition.getProcessInterfaces();
        this.log.finest("Number of interfaces exposed by bpel: " + itfs.size());

        for (final Interface itf : itfs) {

            if (itf != null) {
                final Collection<Endpoint> endpoints = bpelDefinition.getImports()
                        .findEndpointsImplementingInterface(itf);
                this.log.finest("Number of endpoints implementing this interface \""
                        + itf.getQName() + "\" : " + endpoints.size());
                if (!endpoints.isEmpty()) {
                    for (final Endpoint endpoint : endpoints) {
                        this.log.finest(endpoint.getName());
                        if (endpoint.getService() != null) {
                            keys.add(new ProcessKeyImpl(itf.getQName(),
                                    endpoint.getService().getQName(), endpoint
                                            .getName()));
                        } else {
                            throw new CoreException(
                                    "Service not found for this endpoint: "
                                            + endpoint.getName()
                                            + ". An endpoint MUST be associated to a service.");
                        }
                    }
                } else {
                    keys.add(new ProcessKeyImpl(itf.getQName(), null, null));
                }
            } else {
                keys.add(new ProcessKeyImpl(processDefinition.getQName(), null,
                        null));
            }
        }
        return keys;
    }

    @Override
    public <D extends ProcessDefinition> boolean isCreateInstance(D def,
            InternalMessage<?> mess) throws CoreException {

        boolean res = false;
        boolean found = false;

        BPELMessageMatcher matcher = new BPELMessageMatcher(
                ((BPELProcess) def).getImports());

        try {

            List<Receive> receiveActivities = ScopeImpl
                    .findActivityRecursively(Receive.class,
                            ((BPELProcess) def).getActivity());
            if (receiveActivities != null) {
                for (Receive r : receiveActivities) {
                    BPELVariable var = ((BPELProcess) def)
                            .findVariable(new QName(r.getInputVariable()));
                    found = matcher.match(var, mess);
                    if (found) {
                        res = r.getCreateInstance();
                        break;
                    }
                }
                if (!found) {
                    /*
                     * Try to find matching activity : in picks
                     */

                    List<Pick> pickActivities = ScopeImpl
                            .findActivityRecursively(Pick.class,
                                    ((BPELProcess) def).getActivity());

                    if (pickActivities != null) {
                        for (Pick pick : pickActivities) {
                            Iterator<OnMessage> itOnMessages = pick
                                    .getOnMessages().iterator();
                            while (itOnMessages.hasNext() && !found) {
                                OnMessage onM = itOnMessages.next();
                                BPELVariable var = ((BPELProcess) def)
                                        .findVariable(new QName(onM
                                                .getInputVariable()));
                                found = matcher.match(var, mess);
                                if (found) {
                                    res = pick.getCreateInstance();
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        } catch (CoreException e) {

            e.printStackTrace();
            throw new CoreException(
                    "Check createInstance failed (trying to match on receives or pickcs)"
                            + e.getMessage());
        }
        return res;
    }



}
