/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.BPELCompiler;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ForEachImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.VariablePropertyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.BuiltInException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELAssigner;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELCorrelationMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELFaultHandler;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELAssignementExpressionImpl;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.AssignBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.EndpointImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationGroupImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;
import org.petalslink.abslayer.service.api.Role;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={BPELCompiler.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class BPELCompilerImpl
extends AbstractCompiler<BPELProcess>
implements BPELCompiler {
    private static final long serialVersionUID = 1L;
    BPELReader reader;
    DocumentBuilderFactory factory;
    private Logger log = Logger.getLogger(BPELCompilerImpl.class.getName());

    public BPELCompilerImpl() throws BPELException {
        this.reader = BPELFactoryImpl.getInstance().newBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            try {
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return sb.toString();
        }
        is.close();
        return sb.toString();
    }

    public BPELProcess validate(URI uri) throws CoreException {
        BPELProcess bpelprocess = null;
        try {
            com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service service;
            Document bpelSrcDoc;
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            URL url = null;
            InputStream is = null;
            url = uri.isAbsolute() ? uri.toURL() : new URL(new File(".").toURI().toURL(), uri.toString());
            is = url.openStream();
            Document bpeltargetDoc = bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
            if (bpeltargetDoc.getDocumentURI() == null) {
                bpeltargetDoc.setDocumentURI(url.toString().replaceAll(" ", "%20"));
            }
            if ((bpelprocess = this.reader.readBPEL(bpeltargetDoc)).getExtensions() != null && bpelprocess.getExtensions().getExtensions() != null && bpelprocess.getExtensions().getExtensions().size() > 0 && (service = this.getModel().getCore().getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class)) == null) {
                throw new CoreException("Sorry, but the extended Service Manager is not plugged to engine!!!");
            }
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IOException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CoreException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((Throwable)e);
        }
        return bpelprocess;
    }

    public Process generate(Core core, BPELProcess bpelprocess) throws BPELException {
        Process process = null;
        if (core == null) {
            throw new BPELException("Core MUST not be null");
        }
        try {
            process = this.compile(bpelprocess);
        }
        catch (CoreException e) {
            throw new BPELException((Throwable)e);
        }
        return process;
    }

    public Process compile(BPELProcess bpelProcessDefinition) throws CoreException {
        Process process = null;
        try {
            if (bpelProcessDefinition == null) {
                throw new CoreException("bpel process cannot be null !!!");
            }
            this.log.finest("start the compilation");
            process = this.getModel().getCore().getEngine().createNewEmptyProcessInstance(new QName(bpelProcessDefinition.getQName() + "_" + System.nanoTime()), (ProcessDefinition)bpelProcessDefinition);
            BPELAssigner bpelAssigner = new BPELAssigner(bpelProcessDefinition);
            bpelAssigner.setLog(this.log);
            process.setAssigner((Assigner)bpelAssigner);
            this.log.finest("empty process create");
            Node initial = null;
            this.affectVariablesInScope(bpelProcessDefinition, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope)bpelProcessDefinition, (Scope)process);
            for (PartnerLink plt : bpelProcessDefinition.getPartnerLinks()) {
                process.getEndpoints().put(plt, new EndpointImpl());
            }
            if (bpelProcessDefinition.getActivity() != null) {
                initial = this.generateActivity((Scope)process, bpelProcessDefinition.getActivity(), bpelProcessDefinition);
            }
            if (bpelProcessDefinition.getFaultHandlers() != null) {
                this.generateFaultHandlers((Scope)process, bpelProcessDefinition.getFaultHandlers().getCatchs(), bpelProcessDefinition.getFaultHandlers().getCatchAll(), bpelProcessDefinition);
            }
            if (initial == null) {
                throw new CoreException("No main in BPEL process");
            }
            process.setInitialNode(initial);
            this.log.finest("end of the compilation");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return process;
    }

    private void affectVariablesInScope(BPELProcess bpelProcess, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scopeDefinition, Scope scope) throws BPELException {
        BPELMessageMatcher matcher = new BPELMessageMatcher(bpelProcess.getImports());
        if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
            matcher.setLog(this.log);
        }
        for (BPELVariable definition : scopeDefinition.getVariables()) {
            this.addVariableInScope(scope, definition);
        }
    }

    private BPELVariable addVariableInScope(Scope scope, BPELVariable definition) throws BPELException {
        BPELVariable v = (BPELVariable)definition.copypaste();
        scope.getVariables().put(v.getQName(), v);
        return v;
    }

    private Node generateSequence(Scope scope, Sequence sequence, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate sequence");
        Node sequenceNode = null;
        if (sequence != null) {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            for (Activity activity : sequence.getActivities()) {
                activityNode = this.generateActivity(scope, activity, bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity.getName());
            }
            sequenceNode = CreationPatternFactory.getInstance().createSequencePattern(sequence.getName(), childNodes, scope);
        }
        this.log.finest("end generate sequence");
        return sequenceNode;
    }

    private Node generateFlow(Scope scope, Flow flow, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate flow");
        Node flowNode = null;
        if (flow != null) {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            for (Activity activity : flow.getActivities()) {
                activityNode = this.generateActivity(scope, activity, bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity.getName());
            }
            flowNode = CreationPatternFactory.getInstance().createForkPattern(flow.getName(), childNodes, scope);
        }
        this.log.finest("end generate flow");
        return flowNode;
    }

    private Node generateIf(Scope scope, If if_, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate if");
        Node ifNode = null;
        if (if_ != null) {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            ArrayList<BPELBooleanExpression> conditions = new ArrayList<BPELBooleanExpression>();
            for (BPELBooleanExpression exp : if_.getConditions()) {
                BPELBooleanExpression copy = (BPELBooleanExpression)exp.copypaste();
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    copy.setLog(this.log);
                }
                conditions.add(copy);
            }
            for (Activity activity : if_.getActivities()) {
                activityNode = this.generateActivity(scope, activity, bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity + " in if => " + if_.getName());
            }
            ifNode = CreationPatternFactory.getInstance().createIfPattern(if_.getName(), conditions, childNodes, scope);
        }
        this.log.finest("end generate if");
        return ifNode;
    }

    private Node generatePick(Scope scope, Pick pick, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate pick");
        Node pickNode = null;
        if (pick != null) {
            HashMap<Node, Node> childNodes = new HashMap<Node, Node>();
            Node activityNode = null;
            BPELMessageMatcher matcher = new BPELMessageMatcher(bpelprocess.getImports());
            HashMap<String, Object> context = new HashMap<String, Object>();
            for (OnMessage msg : pick.getOnMessages()) {
                if (msg.getActivity() == null) continue;
                context.put("variableNames", Arrays.asList(new QName(msg.getInputVariable())));
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    matcher.setLog(this.log);
                }
                context.put("messageMatcher", matcher);
                if (!pick.getCreateInstance()) {
                    BPELCorrelationMatcher correlationMatcher = new BPELCorrelationMatcher(bpelprocess, msg.getCorrelations(), new QName(msg.getInputVariable()));
                    if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                        correlationMatcher.setLog(this.log);
                    }
                    ArrayList<BPELCorrelationMatcher> corrs = new ArrayList<BPELCorrelationMatcher>();
                    corrs.add(correlationMatcher);
                    context.put("correlationsMatcher", corrs);
                }
                Node receiverNode = scope.createNode(String.valueOf(pick.getName()) + msg.getOperation(), ReceiverBehaviourImpl.class, context);
                activityNode = this.generateActivity(scope, msg.getActivity(), bpelprocess);
                if (activityNode != null) {
                    childNodes.put(receiverNode, activityNode);
                    scope.linkedBrotherNodes(receiverNode, activityNode);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + msg.getActivity());
            }
            int cpt = 0;
            for (OnAlarm alarm : pick.getOnAlarms()) {
                HashMap<String, BPELDurationExpression> context2 = new HashMap<String, BPELDurationExpression>();
                if (alarm.getActivity() != null) {
                    if (alarm.getFor() != null) {
                        context2.put("time", alarm.getFor());
                    } else if (alarm.getUntil() != null) {
                        context2.put("date", alarm.getFor());
                    }
                    Node waitingNode = scope.createNode("alarm" + cpt, WaitBehaviourImpl.class, context2);
                    activityNode = this.generateActivity(scope, alarm.getActivity(), bpelprocess);
                    if (activityNode != null) {
                        childNodes.put(waitingNode, activityNode);
                        scope.linkedBrotherNodes(waitingNode, activityNode);
                    } else {
                        throw new CoreException("Impossible to generate activity: " + alarm.getActivity());
                    }
                }
                ++cpt;
            }
            pickNode = CreationPatternFactory.getInstance().createExclusivePattern(pick.getName(), childNodes, scope);
        }
        this.log.finest("end generate pick");
        return pickNode;
    }

    private Node generateWhile(Scope scope, While while_, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate while");
        Node whileNode = null;
        if (while_ != null) {
            BPELBooleanExpression copy = (BPELBooleanExpression)while_.getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                copy.setLog(this.log);
            }
            ArrayList<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            activityNode = this.generateActivity(scope, while_.getActivity(), bpelprocess);
            if (activityNode == null) {
                throw new CoreException("Impossible to generate activity: " + while_.getActivity());
            }
            childNodes.add(activityNode);
            whileNode = CreationPatternFactory.getInstance().createLoopPattern(while_.getName(), (ConditionalExpression)copy, true, childNodes, scope);
        }
        this.log.finest("end generate while");
        return whileNode;
    }

    private Node generateRepeatUntil(Scope scope, RepeatUntil repeatUntil, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate repeat until");
        Node repeatUntilNode = null;
        if (repeatUntil != null) {
            BPELBooleanExpression copy = (BPELBooleanExpression)repeatUntil.getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                copy.setLog(this.log);
            }
            ArrayList<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            activityNode = this.generateActivity(scope, repeatUntil.getActivity(), bpelprocess);
            if (activityNode == null) {
                throw new CoreException("Impossible to generate activity: " + repeatUntil.getActivity());
            }
            childNodes.add(activityNode);
            repeatUntilNode = CreationPatternFactory.getInstance().createLoopPattern(repeatUntil.getName(), (ConditionalExpression)copy, false, childNodes, scope);
        }
        this.log.finest("end generate repeat until");
        return repeatUntilNode;
    }

    private Node generateForEach(Scope scope, ForEach forEach_, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate forEach");
        Node topScopeNode = null;
        try {
            if (forEach_ != null) {
                Logger logger = null;
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    logger = this.log;
                }
                BPELBooleanExpression condition = ForEachImpl.createBooleanExpressionFromStartAndFinalCounterValue(forEach_, bpelprocess, logger);
                ArrayList<Node> childNodes = new ArrayList<Node>();
                Node underScopeNode = null;
                topScopeNode = CreationPatternFactory.getInstance().createScopePattern("topScope4foarEach_" + forEach_.getName() + "_" + UUID.randomUUID(), scope);
                Scope topScope = (Scope)topScopeNode.getComponent().getFcInterface("service");
                XmlObjectFactory factory = SchemaOfSchemas.getSchema().getXmlContext().getXmlObjectFactory();
                Schema defaultSchema = (Schema)factory.create(Schema.class);
                defaultSchema.setTargetNamespace(bpelprocess.getTargetNamespace());
                Element counter = (Element)factory.create(Element.class);
                counter.setName(forEach_.getCounterName());
                counter.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
                defaultSchema.addElement(counter);
                bpelprocess.getImports().addSchema(defaultSchema);
                TVariable model = new TVariable();
                model.setName(counter.getName());
                model.setElement(counter.inferQName());
                BPELIntVariableImpl v = new BPELIntVariableImpl(model, null, (BPELElement)forEach_);
                topScope.getVariables().put(v.getQName(), v);
                TAssign modelAI = new TAssign();
                modelAI.setName("AssignI");
                TCopy copyAI = new TCopy();
                modelAI.getCopyOrExtensionAssignOperation().add(copyAI);
                TFrom fromAI = new TFrom();
                copyAI.setFrom(fromAI);
                TTo toAI = new TTo();
                copyAI.setTo(toAI);
                fromAI.getContent().add(forEach_.getStartCounterValue().getContent());
                fromAI.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                toAI.getContent().add("$" + forEach_.getCounterName());
                toAI.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                AssignImpl assignI = new AssignImpl(modelAI, null);
                Node assignINode = this.generateAssign(topScope, assignI, bpelprocess);
                topScope.setInitialNode(assignINode);
                if (forEach_.getScope().getName() == null) {
                    forEach_.getScope().setName("underScopeInForEach_" + forEach_.getName() + "_" + UUID.randomUUID());
                }
                if ((underScopeNode = this.generateScope(topScope, forEach_.getScope(), bpelprocess)) == null) {
                    throw new CoreException("Impossible to generate activity: " + forEach_.getScope());
                }
                childNodes.add(underScopeNode);
                TAssign modelAE = new TAssign();
                modelAE.setName("AssignE");
                TCopy copyAE = new TCopy();
                modelAE.getCopyOrExtensionAssignOperation().add(copyAE);
                TFrom fromAE = new TFrom();
                copyAE.setFrom(fromAE);
                TTo toAE = new TTo();
                copyAE.setTo(toAE);
                fromAE.getContent().add("$" + forEach_.getCounterName() + " + 1");
                fromAE.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                toAE.getContent().add("$" + forEach_.getCounterName());
                toAE.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                AssignImpl assignE = new AssignImpl(modelAE, null);
                Node assignENode = this.generateAssign(topScope, assignE, bpelprocess);
                childNodes.add(assignENode);
                Node forEachNode = CreationPatternFactory.getInstance().createLoopPattern(forEach_.getName(), (ConditionalExpression)condition, true, childNodes, topScope);
                topScope.linkedBrotherNodes(assignINode, forEachNode);
            }
            this.log.finest("end generate foreach");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        return topScopeNode;
    }

    private Node generateScope(Scope scope, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scopeDefinition, BPELProcess bpelprocess) throws CoreException {
        try {
            Node scopeNode = null;
            scopeNode = CreationPatternFactory.getInstance().createScopePattern(scopeDefinition.getName(), scope);
            Scope scopeComp = (Scope)scopeNode.getComponent().getFcInterface("service");
            this.affectVariablesInScope(bpelprocess, scopeDefinition, scopeComp);
            for (PartnerLink plt : scopeDefinition.getPartnerLinks()) {
                scope.getEndpoints().put(plt, new EndpointImpl());
            }
            if (scopeDefinition.getActivity() != null) {
                Node initial = this.generateActivity(scopeComp, scopeDefinition.getActivity(), bpelprocess);
                scopeComp.setInitialNode(initial);
            }
            if (scopeDefinition.getFaultHandlers() != null) {
                this.generateFaultHandlers(scopeComp, scopeDefinition.getFaultHandlers().getCatchs(), scopeDefinition.getFaultHandlers().getCatchAll(), bpelprocess);
            }
            return scopeNode;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
    }

    private Node generateInvoke(Scope scope, Invoke invoke, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate invoke");
        Node scopeNode = null;
        Node invokeNode = null;
        try {
            if (invoke == null) {
                throw new CoreException("Invoke cannot be null");
            }
            scopeNode = CreationPatternFactory.getInstance().createScopePattern("scopeOf_" + invoke.getName(), scope);
            Scope scopeComp = (Scope)scopeNode.getComponent().getFcInterface("service");
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("kind", SenderBehaviour.Kind.ASYNCHRONOUS);
            if (invoke.getOutputVariable() != null) {
                context.put("kind", SenderBehaviour.Kind.SYNCHRONOUS);
            }
            context.put("inputVariableName", new QName(invoke.getInputVariable()));
            if (invoke.getOutputVariable() != null) {
                context.put("outputVariableName", new QName(invoke.getOutputVariable()));
            }
            context.put("faultHandler", new BPELFaultHandler(bpelprocess, invoke));
            PartnerLink partner = bpelprocess.getPartnerLink(invoke.getPartnerLink());
            if (partner == null) {
                throw new CoreException("Impossible to find partner with name: " + invoke.getPartnerLink());
            }
            com.ebmwebsourcing.easyviper.core.api.soa.Endpoint providerEndpoint = scope.findEndpoint((Object)partner);
            SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess, providerEndpoint, scope);
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                soapAdapter.setLog(this.log);
            }
            context.put("messageAdapter", soapAdapter);
            providerEndpoint.setInterfaceName(invoke.getInterface());
            if (providerEndpoint.getInterfaceName() == null) {
                PartnerLinkType partnerLinkType = bpelprocess.getImports().getPartnerLinkType(partner.getPartnerLinkType());
                if (partnerLinkType == null) {
                    throw new CoreException("Impossible to find partner link type with name: " + partner.getPartnerLinkType());
                }
                Role role = partnerLinkType.getRole(partner.getPartnerRole());
                if (role == null) {
                    throw new CoreException("Impossible to find role with name: " + partner.getPartnerRole());
                }
                providerEndpoint.setInterfaceName(role.getInterfaceQName());
            }
            if (providerEndpoint.getInterfaceName() == null) {
                throw new CoreException("Impossible to find interface to invoke");
            }
            Interface itf = bpelprocess.getImports().findInterface(providerEndpoint.getInterfaceName());
            if (itf == null) {
                throw new CoreException("Impossible to find this interface: " + providerEndpoint.getInterfaceName());
            }
            Description abstraiteDescription = bpelprocess.getImports().getDescriptionByInterface(itf.getQName());
            Description concreteDescription = null;
            Collection endpoints = bpelprocess.getImports().findEndpointsImplementingInterface(itf);
            if (!endpoints.isEmpty()) {
                Endpoint firstPossibleEndpoint = (Endpoint)endpoints.iterator().next();
                providerEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                providerEndpoint.setServiceName(firstPossibleEndpoint.getService().getQName());
                concreteDescription = bpelprocess.getImports().getDescriptionByService(firstPossibleEndpoint.getService().getQName());
            }
            if (concreteDescription != null) {
                providerEndpoint.setDescription(concreteDescription);
            } else {
                providerEndpoint.setDescription((Object)abstraiteDescription);
            }
            context.put("operationName", invoke.getOperation());
            context.put("providerEndpointKey", partner);
            invokeNode = scopeComp.createNode(invoke.getName(), SenderBehaviourImpl.class, context);
            scope.getEndpoints().put(partner, providerEndpoint);
            this.initiateCorrelations(scope, invoke.getCorrelations(), invoke.getInputVariable(), bpelprocess);
            scopeComp.setInitialNode(invokeNode);
            this.generateFaultHandlers(scopeComp, invoke.getCatchs(), invoke.getCatchAll(), bpelprocess);
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("end generate invoke");
        return scopeNode;
    }

    private void generateFaultHandlers(Scope parentScope, List<Catch> catchs, CatchAll cathAll, BPELProcess bpelprocess) throws CoreException, NoSuchInterfaceException, BPELException {
        this.log.finest("start generate generateFaultHandlers");
        for (Catch catch_ : catchs) {
            Node catchScope = CreationPatternFactory.getInstance().createScopePattern("catchScopeOf_" + catch_.getFaultName(), parentScope);
            Scope catchScopeComp = (Scope)catchScope.getComponent().getFcInterface("service");
            FaultImpl fault = new FaultImpl();
            if (catch_.getFaultName() != null) {
                fault.setFaultName(catch_.getFaultName());
            } else {
                fault.setFaultName(new QName("unknown"));
            }
            Object faultVar = null;
            if (catch_.getFaultVariable() != null) {
                faultVar = (BPELVariable)parentScope.findVariable(new QName(catch_.getFaultVariable()));
            }
            if (faultVar == null && catch_.getFaultVariable() != null) {
                TVariable fvar = new TVariable();
                fvar.setElement(catch_.getFaultElement());
                fvar.setMessageType(catch_.getFaultMessageType());
                fvar.setName(catch_.getFaultVariable());
                faultVar = new BPELElementVariableImpl(fvar, null, (BPELElement)catch_);
                this.addVariableInScope(catchScopeComp, (BPELVariable)faultVar);
            }
            fault.setVariable(faultVar);
            fault.setFaultHandler((FaultHandler)new BPELFaultHandler(bpelprocess, null));
            parentScope.getExceptions().put(fault, catchScopeComp);
            Node activityNode = this.generateActivity(catchScopeComp, catch_.getActivity(), bpelprocess);
            catchScopeComp.setInitialNode(activityNode);
        }
        if (cathAll != null) {
            Node catchScope = CreationPatternFactory.getInstance().createScopePattern("catchScopeOf_catchAll", parentScope);
            Scope catchScopeComp = (Scope)catchScope.getComponent().getFcInterface("service");
            FaultImpl fault = new FaultImpl();
            fault.setFaultName(new QName("unknown"));
            fault.setFaultHandler((FaultHandler)new BPELFaultHandler(bpelprocess, null));
            parentScope.getExceptions().put(fault, catchScopeComp);
            catchScope.setParentNode((Node)parentScope);
            Node activityNode = this.generateActivity(catchScopeComp, cathAll.getActivity(), bpelprocess);
            catchScopeComp.setInitialNode(activityNode);
        }
        this.log.finest("end generate generateFaultHandlers");
    }

    private void initiateCorrelations(Scope scope, List<Correlation> correlations, String inputVariable, BPELProcess bpelprocess) throws BPELException {
        try {
            if (correlations != null && correlations.size() > 0) {
                this.log.finest("number of correlations defined in this activity: " + correlations.size());
                for (Correlation correlation : correlations) {
                    if (!correlation.getInitiate().equals((Object)TInitiate.YES) && !correlation.getInitiate().equals((Object)TInitiate.JOIN)) continue;
                    if (scope.findCorrelationGroups(correlation.getSet()).size() == 0) {
                        CorrelationSet correlationSet = bpelprocess.getCorrelationSet(correlation.getSet());
                        if (correlationSet == null) {
                            throw new BPELException("Impossible to find the correlation set corresponding to this name " + correlation.getSet());
                        }
                        Variable var = scope.findVariable(new QName(inputVariable));
                        BPELVariable varDef = (BPELVariable)var;
                        if (var == null) {
                            throw new BPELException("Impossible to find variable corresponding to this name " + inputVariable);
                        }
                        CorrelationGroupImpl correlationGroup = new CorrelationGroupImpl();
                        HashMap<String, CorrelationImpl> coreCorrelations = new HashMap<String, CorrelationImpl>();
                        correlationGroup.setCorrelations(coreCorrelations);
                        List propertiesName = correlationSet.getProperties();
                        for (QName propertyName : propertiesName) {
                            Property prop = bpelprocess.getImports().getProperty(propertyName);
                            if (prop == null) {
                                throw new BPELException("Impossible to find property corresponding to this name " + propertyName);
                            }
                            List propertiesAliases = bpelprocess.getImports().getPropertyAliases4ThisProperty(prop.getQName());
                            if (propertiesAliases == null) continue;
                            for (PropertyAlias propertyAlias : propertiesAliases) {
                                boolean correlationMatching = false;
                                if (propertyAlias.getElement() != null && propertyAlias.getElement().equals(varDef.getElement())) {
                                    correlationMatching = true;
                                } else if (propertyAlias.getMessageType() != null && propertyAlias.getMessageType().equals(varDef.getMessageType())) {
                                    correlationMatching = true;
                                } else if (propertyAlias.getType() != null && propertyAlias.getType().equals(varDef.getTypeQName())) {
                                    correlationMatching = true;
                                }
                                if (!correlationMatching) continue;
                                ToImpl to = new ToImpl(new TTo(), null);
                                to.setKind(FromAndTo.Kind.VARIABLE_PROPERTY);
                                to.setVariableProperty(new VariablePropertyImpl(inputVariable, prop.getQName()));
                                FromImpl from = new FromImpl(new TFrom(), null);
                                from.setKind(FromAndTo.Kind.VARIABLE_PROPERTY);
                                CorrelationImpl corr = new CorrelationImpl();
                                corr.setName(correlation.getSet());
                                corr.setOrignator((Expression)to);
                                corr.setFollower((Expression)from);
                                coreCorrelations.put(corr.getName(), corr);
                            }
                        }
                        if (coreCorrelations.size() > 0) {
                            scope.getProcess().getCorrelationGroups().add(correlationGroup);
                        }
                        this.log.finest("Correlation " + correlation.getSet() + " created and added to scope: " + scope.getProcess().getName());
                        continue;
                    }
                    this.log.finest("Correlation " + correlation.getSet() + " already created");
                }
            }
        }
        catch (CoreException e) {
            throw new BPELException((Throwable)e);
        }
    }

    private Node generateReply(Scope scope, Reply reply, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate reply");
        Node replyNode = null;
        try {
            if (reply != null) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("kind", SenderBehaviour.Kind.ASYNCHRONOUS);
                PartnerLink partner = bpelprocess.getPartnerLink(reply.getPartnerLink());
                if (partner == null) {
                    throw new CoreException("Impossible to find partner with name: " + reply.getPartnerLink());
                }
                context.put("inputVariableName", new QName(reply.getOutputVariable()));
                String plString = reply.getPartnerLink();
                PartnerLink partnerlink = bpelprocess.findPartnerLink(plString);
                com.ebmwebsourcing.easyviper.core.api.soa.Endpoint myRoleEndpoint = scope.findEndpoint((Object)partnerlink);
                Interface itf = null;
                if (reply.getInterface() != null) {
                    itf = bpelprocess.getImports().findInterface(reply.getInterface());
                    if (itf == null) {
                        throw new CoreException("Impossible to find interface corresponding to " + reply.getInterface());
                    }
                } else {
                    PartnerLink pl;
                    String pls = reply.getPartnerLink();
                    if (pls != null && (pl = bpelprocess.getPartnerLink(pls)) != null) {
                        QName plt = pl.getPartnerLinkType();
                        PartnerLinkType pLT = bpelprocess.getImports().getPartnerLinkType(plt);
                        Role r = pLT.getRole(pl.getMyRole());
                        itf = bpelprocess.getImports().findInterface(r.getInterfaceQName());
                    }
                }
                if (itf == null) {
                    throw new CoreException("Impossible to find interface corresponding to " + reply.getInterface() + " ...");
                }
                Description abstraiteDescription = bpelprocess.getImports().getDescriptionByInterface(itf.getQName());
                Description concreteDescription = null;
                Collection endpoints = bpelprocess.getImports().findEndpointsImplementingInterface(itf);
                if (!endpoints.isEmpty()) {
                    Endpoint firstPossibleEndpoint = (Endpoint)endpoints.iterator().next();
                    myRoleEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                    myRoleEndpoint.setServiceName(firstPossibleEndpoint.getService().getQName());
                    concreteDescription = bpelprocess.getImports().getDescriptionByService(firstPossibleEndpoint.getService().getQName());
                }
                if (reply.getInterface() != null) {
                    myRoleEndpoint.setInterfaceName(reply.getInterface());
                }
                if (reply.getOperation() != null) {
                    context.put("operationName", reply.getOperation());
                    myRoleEndpoint.setInvokedOperation(reply.getOperation());
                }
                if (itf != null) {
                    myRoleEndpoint.setDescription((Object)itf.getParentDescription());
                }
                context.put("providerEndpointKey", partner);
                SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess, myRoleEndpoint, scope);
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    soapAdapter.setLog(this.log);
                }
                context.put("messageAdapter", soapAdapter);
                replyNode = scope.createNode(reply.getName(), SenderBehaviourImpl.class, context);
                this.initiateCorrelations(scope, reply.getCorrelations(), reply.getOutputVariable(), bpelprocess);
            }
            this.log.finest("end generate reply");
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        return replyNode;
    }

    private Node generateReceive(Scope scope, Receive receive, BPELProcess bpelprocess) throws CoreException {
        Node receiveNode = null;
        this.log.finest("start generate receive");
        try {
            if (receive != null) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                this.initiateCorrelations(scope, receive.getCorrelations(), receive.getInputVariable(), bpelprocess);
                context.put("variableNames", Arrays.asList(new QName(receive.getInputVariable())));
                this.log.finest("create receiver behaviour");
                PartnerLink partner = bpelprocess.getPartnerLink(receive.getPartnerLink());
                if (partner == null) {
                    throw new CoreException("Impossible to find partner with name: " + receive.getPartnerLink());
                }
                context.put("providerEndpointKey", partner);
                com.ebmwebsourcing.easyviper.core.api.soa.Endpoint clientEndpoint = scope.findEndpoint((Object)partner);
                SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess, clientEndpoint, scope);
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    soapAdapter.setLog(this.log);
                }
                clientEndpoint.setInterfaceName(receive.getInterface());
                if (clientEndpoint.getInterfaceName() == null) {
                    PartnerLinkType partnerLinkType = bpelprocess.getImports().getPartnerLinkType(partner.getPartnerLinkType());
                    if (partnerLinkType == null) {
                        throw new CoreException("Impossible to find partner link type with name: " + partner.getPartnerLinkType());
                    }
                    Role role = partnerLinkType.getRole(partner.getMyRole());
                    if (role == null) {
                        throw new CoreException("Impossible to find role with name: " + partner.getPartnerRole());
                    }
                    clientEndpoint.setInterfaceName(role.getInterfaceQName());
                }
                if (clientEndpoint.getInterfaceName() == null) {
                    throw new CoreException("Impossible to find interface to invoke");
                }
                Interface itf = bpelprocess.getImports().findInterface(clientEndpoint.getInterfaceName());
                if (itf == null) {
                    throw new CoreException("Impossible to find this interface: " + clientEndpoint.getInterfaceName());
                }
                Description abstraiteDescription = bpelprocess.getImports().getDescriptionByInterface(itf.getQName());
                Description concreteDescription = null;
                Collection endpoints = bpelprocess.getImports().findEndpointsImplementingInterface(itf);
                if (endpoints != null && endpoints.size() > 0) {
                    Endpoint firstPossibleEndpoint = (Endpoint)endpoints.iterator().next();
                    clientEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                    clientEndpoint.setServiceName(firstPossibleEndpoint.getService().getQName());
                    concreteDescription = bpelprocess.getImports().getDescriptionByService(firstPossibleEndpoint.getService().getQName());
                }
                if (concreteDescription != null) {
                    clientEndpoint.setDescription(concreteDescription);
                } else {
                    clientEndpoint.setDescription((Object)abstraiteDescription);
                }
                scope.getEndpoints().put(partner, clientEndpoint);
                BPELMessageMatcher matcher = new BPELMessageMatcher(bpelprocess.getImports());
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    matcher.setLog(this.log);
                }
                context.put("messageMatcher", matcher);
                if (!receive.getCreateInstance()) {
                    ArrayList<Correlation> correlations = receive.getCorrelations();
                    if (correlations == null && receive.getCreateInstance()) {
                        correlations = new ArrayList<Correlation>();
                    }
                    BPELCorrelationMatcher correlationMatcher = new BPELCorrelationMatcher(bpelprocess, correlations, new QName(receive.getInputVariable()));
                    if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                        correlationMatcher.setLog(this.log);
                    }
                    ArrayList<BPELCorrelationMatcher> corrs = new ArrayList<BPELCorrelationMatcher>();
                    corrs.add(correlationMatcher);
                    context.put("correlationsMatcher", corrs);
                }
                receiveNode = scope.createNode(receive.getName(), ReceiverBehaviourImpl.class, context);
                this.log.finest("create receiver scope");
            }
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("end generate receive");
        return receiveNode;
    }

    private Node generateAssign(Scope scope, Assign assign, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate assign");
        Node assignNode = null;
        if (assign != null) {
            HashMap<String, ArrayList<BPELAssignementExpressionImpl>> context = new HashMap<String, ArrayList<BPELAssignementExpressionImpl>>();
            for (Copy copy : assign.getCopy()) {
                ArrayList<BPELAssignementExpressionImpl> list;
                BPELAssignementExpressionImpl assignExp = new BPELAssignementExpressionImpl(copy, bpelprocess);
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    assignExp.setLog(this.log);
                }
                if ((list = (ArrayList<BPELAssignementExpressionImpl>)context.get("assignements")) == null) {
                    list = new ArrayList<BPELAssignementExpressionImpl>();
                }
                list.add(assignExp);
                context.put("assignements", list);
            }
            assignNode = scope.createNode(assign.getName(), AssignBehaviourImpl.class, context);
        }
        this.log.finest("end generate assign");
        return assignNode;
    }

    private Node generateEmpty(Scope scope, Empty empty, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate empty");
        Node emptyNode = scope.createNode(empty.getName(), EmptyBehaviourImpl.class, null);
        return emptyNode;
    }

    private Node generateWait(Scope scope, Wait wait, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate wait");
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (wait.getUntil() != null) {
            context.put("date", (DateExpression)wait.getUntil().copypaste());
        }
        if (wait.getFor() != null) {
            context.put("time", (LongExpression)wait.getFor().copypaste());
        }
        Node waitNode = scope.createNode(wait.getName(), WaitBehaviourImpl.class, context);
        return waitNode;
    }

    private Node generateThrow(Scope scope, Throw thrw, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate throw");
        HashMap<String, BPELException> context = new HashMap<String, BPELException>();
        try {
            if (thrw.getFaultName().getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
                BuiltInException builtinException = BuiltInException.valueOfBPELBuiltInExceptionFrom(thrw.getFaultName().getLocalPart());
                if (builtinException == null) {
                    throw new CoreException("Impossible to find built in exception constant from this value: " + thrw.getFaultName());
                }
                Class<?> bpelException = ((Object)((Object)builtinException)).getClass();
                Constructor<?> constructor = bpelException.getConstructor(new Class[0]);
                BPELException builtInException = (BPELException)((Object)constructor.newInstance(new Object[0]));
                context.put("exception", builtInException);
            } else {
                BPELVariable variable = (BPELVariable)scope.findVariable(new QName(thrw.getFaultVariable()));
                UserDefinedException userException = null;
                if (variable.getElement() != null) {
                    this.log.finest("Creating new UserDefinedException based on a variable element");
                    userException = new UserDefinedException(thrw.getFaultName(), thrw.getFaultVariable(), UserDefinedException.FaultQnameType.ELEMENT_QNAME, variable.getElement(), scope);
                } else {
                    this.log.finest("Creating new UserDefinedException based on a variable message");
                    userException = new UserDefinedException(thrw.getFaultName(), thrw.getFaultVariable(), UserDefinedException.FaultQnameType.MESSAGE_QNAME, variable.getMessageType(), scope);
                }
                context.put("exception", userException);
            }
        }
        catch (SecurityException e) {
            throw new CoreException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CoreException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new CoreException((Throwable)e);
        }
        Node throwNode = scope.createNode(thrw.getName(), ThrowBehaviourImpl.class, context);
        return throwNode;
    }

    private Node generateExit(Scope scope, Exit exit, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate exit");
        Node exitNode = scope.createNode(exit.getName(), ExitBehaviourImpl.class, null);
        return exitNode;
    }

    private Node generateReThrow(Scope scope, ReThrow rethrow, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate rethrow");
        Node rethrowNode = scope.createNode(rethrow.getName(), ReThrowBehaviourImpl.class, null);
        this.log.finest("end generate rethrow");
        return rethrowNode;
    }

    private Node generateActivity(Scope scope, Activity activity, BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate activty: " + activity);
        Node activityNode = null;
        if (activity != null) {
            if (activity instanceof Empty) {
                activityNode = this.generateEmpty(scope, (Empty)activity, bpelprocess);
            } else if (activity instanceof Wait) {
                activityNode = this.generateWait(scope, (Wait)activity, bpelprocess);
            } else if (activity instanceof Sequence) {
                activityNode = this.generateSequence(scope, (Sequence)activity, bpelprocess);
            } else if (activity instanceof Flow) {
                activityNode = this.generateFlow(scope, (Flow)activity, bpelprocess);
            } else if (activity instanceof If) {
                activityNode = this.generateIf(scope, (If)activity, bpelprocess);
            } else if (activity instanceof While) {
                activityNode = this.generateWhile(scope, (While)activity, bpelprocess);
            } else if (activity instanceof RepeatUntil) {
                activityNode = this.generateRepeatUntil(scope, (RepeatUntil)activity, bpelprocess);
            } else if (activity instanceof ForEach) {
                activityNode = this.generateForEach(scope, (ForEach)activity, bpelprocess);
            } else if (activity instanceof Invoke) {
                activityNode = this.generateInvoke(scope, (Invoke)activity, bpelprocess);
            } else if (activity instanceof Receive) {
                activityNode = this.generateReceive(scope, (Receive)activity, bpelprocess);
            } else if (activity instanceof Reply) {
                activityNode = this.generateReply(scope, (Reply)activity, bpelprocess);
            } else if (activity instanceof Assign) {
                activityNode = this.generateAssign(scope, (Assign)activity, bpelprocess);
            } else if (activity instanceof Pick) {
                activityNode = this.generatePick(scope, (Pick)activity, bpelprocess);
            } else if (activity instanceof com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope) {
                activityNode = this.generateScope(scope, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope)activity, bpelprocess);
            } else if (activity instanceof Throw) {
                activityNode = this.generateThrow(scope, (Throw)activity, bpelprocess);
            } else if (activity instanceof ReThrow) {
                activityNode = this.generateReThrow(scope, (ReThrow)activity, bpelprocess);
            } else if (activity instanceof Exit) {
                activityNode = this.generateExit(scope, (Exit)activity, bpelprocess);
            } else if (activity instanceof ExtensionActivity) {
                activityNode = this.generateExtendedActivity(scope, ((ExtensionActivity)activity).getExtendedActivity(), bpelprocess);
            } else {
                throw new CoreException("unknown activity: " + activity);
            }
        }
        this.log.finest("end generate activity");
        return activityNode;
    }

    private Node generateExtendedActivity(Scope scope, ExtendedActivity activity, BPELProcess bpelprocess) throws CoreException {
        Node node = null;
        node = activity != null ? activity.generate(scope) : scope.createNode(null, EmptyBehaviourImpl.class, null);
        return node;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

