/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ForEachImpl extends ActivityImpl<TForEach> implements ForEach {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	private static Logger log = Logger.getLogger(ForEachImpl.class.getName());
	
	
	private Scope scope = null;

	private BPELExpression startCounterValue;
	
	private BPELExpression finalCounterValue;
	
	public ForEachImpl(final TForEach model, final BPELElement parent) {
		super(Constants._ForEach_QNAME, model, parent);
		
		if(this.model.getScope() != null) {
			this.scope = new ScopeImpl(this.model.getScope(), this);
		}
		
		if(this.model.getStartCounterValue() != null) {
			this.startCounterValue = new BPELExpressionImpl(this.model.getStartCounterValue(), this);
		}
		
		if(this.model.getFinalCounterValue() != null) {
			this.finalCounterValue = new BPELExpressionImpl(this.model.getFinalCounterValue(), this);
		}
	}

	public Scope getScope() {
		return this.scope;
	}

	public String getCounterName() {
		return this.model.getCounterName();
	}

	public BPELExpression getFinalCounterValue() {
		return this.finalCounterValue;
	}

	public BPELExpression getStartCounterValue() {
		return this.startCounterValue;
	}

	public static BPELExpression createBooleanExpressionFromStartAndFinalCounterValue(final ForEach forEach, final BPELProcess process, final Logger logger) throws XPathExpressionException {
		String condition = 
				forEach.getStartCounterValue().getContent() + " <= " + "$" + forEach.getCounterName() + " and " + "$" + forEach.getCounterName() + " <= " + forEach.getFinalCounterValue().getContent();
		final BPELExpression res = new BPELExpressionImpl(condition, (ForEachImpl) forEach);
		return res;
	}

	
}
