/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TActivityContainer;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TElseif;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class IfImpl extends ActivityImpl<TIf> implements If {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private List<BPELExpression> conditions = new ArrayList<BPELExpression>();

	private List<Activity> activities = new ArrayList<Activity>();

	public IfImpl(final TIf model, final BPELElement parent)  {
		super(Constants._If_QNAME, model, parent);



		// get conditions
		if(this.model.getCondition() != null) {
			BPELExpression exp = new BPELExpressionImpl(this.model.getCondition(), parent);
			this.conditions.add(exp);
		}
		for(final TElseif elseIf: this.model.getElseif()) {
			if(elseIf.getCondition() != null)  {
				BPELExpression expElse = new BPELExpressionImpl(elseIf.getCondition(), parent);
				this.conditions.add(expElse);
			}
		}

		// get activities
		try {
			this.activities.add(ActivityImpl.analyzeIfActivity(this.model, this));
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In if " + this.getName() + " => " + e.getMessage(), e)));
		}
		int i = 1;
		for(final TElseif elseIf: this.model.getElseif()) {
			try {
				this.activities.add(ActivityImpl.analyzeElseIfActivity(elseIf, this));
				i++;
			} catch (final BPELException e) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In elseif " + i + " of if " + this.getName() + " => " + e.getMessage(), e)));
			}
		}

		if(this.model.getElse() != null) {
			try {
				this.activities.add(ActivityImpl.analyzeActivityContainer(this.model.getElse(), this));
			} catch (final BPELException e) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In else of if " + this.getName() + " => " + e.getMessage(), e)));
			}
		}

	}



	public List<Activity> getActivities() {
		return this.activities;
	}




	public List<BPELExpression> getConditions() {
		return this.conditions;
	}


	public void addIfActivity(BPELExpression exp, Activity a) throws BPELException {
		if(exp != null) {
			this.model.setCondition((TBooleanExpr) ((BPELExpressionImpl)exp).getModel());
			this.conditions.add(exp);
		}
		if(a != null) {
			ActivityImpl.setActivityToIf(a, this);
			this.activities.add(a);
		}
	}

	public void addElseIfActivity(BPELExpression exp, Activity a) throws BPELException {
		TElseif elseif = new TElseif();
		if(exp != null) {
			elseif.setCondition((TBooleanExpr) ((BPELExpressionImpl)exp).getModel());
			this.conditions.add(exp);
		}
		if(a != null) {
			ActivityImpl.setActivityToElseIf(a, elseif);
			this.model.getElseif().add(elseif);
			this.activities.add(a);
		}
	}

	public void setElseActivity(Activity a) throws BPELException {
		if(a != null) {
			this.model.setElse(new TActivityContainer());
			ActivityImpl.setActivityToActivityContainer(a, this.model.getElse());
			this.activities.add(a);
		}
	}

	//TODO to check
	public Activity getElseActivity(){
		return this.activities.get(this.activities.size()-1);
	}

	//TODO to check
	public void removeElseIfActivity(BPELExpression boolExpr, Activity activity){
		
		int conditionIndex = this.activities.indexOf(boolExpr);
		
		TElseif elseif = this.model.getElseif().get(conditionIndex);
		
		this.conditions.remove(conditionIndex);
		
		this.activities.remove(conditionIndex);
		
		this.model.getElseif().remove(elseif);
		
	}
	
	
}
