/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class RepeatUntilImpl extends ActivityImpl<TRepeatUntil> implements RepeatUntil {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private BPELExpression condition = null;

	private Activity activity = null;

	public RepeatUntilImpl(final TRepeatUntil model, final BPELElementImpl parent) {
		super(Constants._RepeatUntil_QNAME, model, parent);

		if(this.model.getCondition() != null) {
			this.condition = new BPELExpressionImpl(this.model.getCondition(), parent);
		}
		try {
			this.activity = ActivityImpl.analyzeRepeatUntilActivity(this.model, this);
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In repeatUntil " + this.getName() + " => " + e.getMessage(), e)));
		}
	}

	public Activity getActivity() {
		return this.activity;
	}

	public BPELExpression getCondition() {
		return this.condition;
	}

	public void setActivity(final Activity activity) {
		this.activity = activity;
	}

	public void setCondition(final BPELExpression condition) {
		this.condition = condition;
	}



}
