/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCompensate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCompensateScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TRethrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TThrow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TValidate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WhileImpl extends ActivityImpl<TWhile> implements While {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private BPELExpression condition = null;

	private Activity activity = null;

	public WhileImpl(final TWhile model, final BPELElement parent) {
		super(Constants._While_QNAME, model, parent);

		if(this.model.getCondition() != null) {
			this.condition = new BPELExpressionImpl(this.model.getCondition(), parent);
		}
		
		try {
			this.activity = ActivityImpl.analyzeWhileActivity(this.model, this);
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In while " + this.getName() + " => " + e.getMessage(), e)));
		}
	}

	public Activity getActivity() {
		return this.activity;
	}

	public BPELExpression getCondition() {
		return this.condition;
	}

	
	@SuppressWarnings("unchecked")
	public void setActivity(final Activity activity) {
		this.activity = activity;
		
		Object activityModel = ((AbstractSchemaElementImpl)activity).getModel();
		if(activityModel instanceof TAssign){
			this.model.setAssign((TAssign)activityModel);
		}
		else if(activityModel instanceof TCompensate){
			this.model.setCompensate((TCompensate)activityModel);
		}
		else if(activityModel instanceof TCompensateScope){
			this.model.setCompensateScope((TCompensateScope)activityModel);
		}
		else if(activityModel instanceof TEmpty){
			this.model.setEmpty((TEmpty)activityModel);
		}
		else if(activityModel instanceof TExit){
			this.model.setExit((TExit)activityModel);
		}
		else if(activityModel instanceof TExtensionActivity){
			this.model.setExtensionActivity((TExtensionActivity)activityModel);
		}
		else if(activityModel instanceof TFlow){
			this.model.setFlow((TFlow)activityModel);
		}
		else if(activityModel instanceof TForEach){
			this.model.setForEach((TForEach)activityModel);
		}
		else if(activityModel instanceof TIf){
			this.model.setIf((TIf)activityModel);
		}
		else if(activityModel instanceof TInvoke){
			this.model.setInvoke((TInvoke)activityModel);
		}
		else if(activityModel instanceof TPick){
			this.model.setPick((TPick)activityModel);
		}
		else if(activityModel instanceof TReceive){
			this.model.setReceive((TReceive)activityModel);
		}
		else if(activityModel instanceof TRepeatUntil){
			this.model.setRepeatUntil((TRepeatUntil)activityModel);
		}
		else if(activityModel instanceof TReply){
			this.model.setReply((TReply)activityModel);
		}
		else if(activityModel instanceof TRethrow){
			this.model.setRethrow((TRethrow)activityModel);
		}
		else if(activityModel instanceof TScope){
			this.model.setScope((TScope)activityModel);
		}
		else if(activityModel instanceof TSequence){
			this.model.setSequence((TSequence)activityModel);
		}
		else if(activityModel instanceof TThrow){
			this.model.setThrow((TThrow)activityModel);
		}
		else if(activityModel instanceof TValidate){
			this.model.setValidate((TValidate)activityModel);
		}
		else if(activityModel instanceof TWait){
			this.model.setWait((TWait)activityModel);
		}
		else if(activityModel instanceof TWhile){
			this.model.setWhile((TWhile)activityModel);
		}
		else{
			throw new IllegalArgumentException("This activity is not supported : "+activity.getClass().toString());
		}
		
		((AbstractSchemaElementImpl)this.activity).setParent(this);
	}

	
	@SuppressWarnings("unchecked")
	public void setCondition(final BPELExpression condition) {
		this.condition = condition;
		this.model.setCondition((TBooleanExpr) ((AbstractSchemaElementImpl)condition).getModel());
		((AbstractSchemaElementImpl)this.condition).setParent(this);
	}


}
