
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XMLElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;
import org.petalslink.abslayer.service.api.PropertyAlias;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.Validator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.TypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TQuery;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.SelectionFailureException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public abstract class AbstractFromOrToImpl<M> extends AbstractSchemaElementImpl<M> implements
        BPELElement, XMLElement, Validator {

    public AbstractFromOrToImpl() {
        super();
    }

    public AbstractFromOrToImpl(M model, AbstractSchemaElementImpl parent) {
        super(model, parent);
    }

    protected final Object resolveFromVariablePart(Execution execution, String variableName, String partName) {
        assert variableName != null;
        assert partName != null;
        Scope scope = execution.getCurrentScope();
        Variable variable = scope.findVariable(variableName);

        if (!(variable instanceof MessageTypeVariable))
            throw new UncheckedException(
                    String.format("Variable '%s' should refer to a message type", variableName));
        MessageTypeVariable messageTypeVariable = (MessageTypeVariable) variable;

        Element element = messageTypeVariable.getValue(execution);

        int partIndex = findPartIndex(messageTypeVariable, partName);
        if ((partIndex == -1) || (partIndex >= element.getChildren().size()))
            throw new UncheckedException(String.format(
                    "Could not find part '%s' in variable '%s'.", partName, variableName));

        Element partElement = (Element) element.getChildren().get(partIndex);
        if (!hasQuery())
            return partElement;
        Expression query = getQuery();

        ExpressionEvaluator expressionEvaluator = scope.getExpressionEvaluator();
        Object result = expressionEvaluator.evaluateAsNode(execution, query, partElement);
        if (result == null)
            throw new SelectionFailureException(query);
        return result;
    }
    


    protected final Object resolveFromVariable(Execution execution, String variableName) {
        assert variableName != null;
        if (!hasQuery())
        	return execution.getVariableValue(variableName);
        
        Expression query = getQuery();

        Scope scope = execution.getCurrentScope();
        ExpressionEvaluator expressionEvaluator = scope.getExpressionEvaluator();
        Object result = expressionEvaluator.evaluateAsNode(execution, query, execution.getVariableValue(variableName));
        if (result == null)
            throw new SelectionFailureException(query);
        return result;
    }    

    
    
    protected final Object resolveFromExpression(Execution execution, Expression expression) {
        Scope scope = execution.getCurrentScope();
        ExpressionEvaluator expressionEvaluator = scope.getExpressionEvaluator();
        Object result = expressionEvaluator.evaluateAsNode(execution, expression, null);
        if (result == null)
            throw new SelectionFailureException(expression);
        return result;
    }
    

    @SuppressWarnings("unchecked")
    protected final Expression getQuery(List<Object> content) {
        for (Object o : content) {
            if (o instanceof JAXBElement<?>) {
                JAXBElement<TQuery> jaxbElement = (JAXBElement<TQuery>) o;
                TQuery query = jaxbElement.getValue();
                if ((query.getContent() == null) || (query.getContent().isEmpty()))
                    break;
                StringBuffer sb = new StringBuffer();
                for (Object s : query.getContent()) {
                    sb.append(String.valueOf(s));
                }
                return new BPELExpressionImpl(sb.toString().trim(), this);
            }
        }
        return null;
    }

    protected Expression getExpression(List<Object> content) {
        if (content == null)
            return null;
        if (content.isEmpty())
            return null;
        Object firstContent = cleanContent(content).get(0); 
        if (firstContent instanceof TExpression) {
            return new BPELExpressionImpl((TExpression) firstContent, this);
        } else if (firstContent instanceof String) {
            return new BPELExpressionImpl((String) firstContent, this);
        } else {
            return null;
        }
    }

    private List<Object> cleanContent(List<Object> content) {
    	List<Object> res = new ArrayList<Object>();
    	for(Object obj: content) {
    		if(obj instanceof String && !obj.toString().trim().isEmpty()) {
    			res.add(obj);
    		} else if(!(obj instanceof String)) {
    			res.add(obj);
    		}
    	}
		return res;
	}

	public final boolean hasExpression() {
        return getExpression() != null;
    }

    public abstract Expression getExpression();

    public final boolean hasPartnerLink() {
        return getPartnerLink() != null;
    }

    public abstract String getPartnerLink();

    public final boolean hasVariable() {
        return getVariable() != null;
    }

    public abstract String getVariable();

    public final boolean hasPart() {
        return getPart() != null;
    }

    public abstract String getPart();

    public final boolean hasProperty() {
        return getProperty() != null;
    }

    public abstract QName getProperty();

    public final boolean hasQuery() {
        return getQuery() != null;
    }

    public abstract Expression getQuery();

    @Override
    public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addOtherElements(org.w3c.dom.Element elmt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QName getTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTag(QName name) {
        throw new UnsupportedOperationException();
    }

    @SuppressWarnings("unchecked")
    private int findPartIndex(MessageTypeVariable messageTypeVariable, String partName) {
        assert messageTypeVariable != null;
        assert partName != null;
        AbstractSchemaElementImpl<TVariable> varImpl = ((AbstractSchemaElementImpl<TVariable>) messageTypeVariable);
        TVariable varDef = varImpl.getModel();
        BPELProcessImpl bpelProcess = (BPELProcessImpl) varImpl.getTopParent();
        Message message = bpelProcess.getImports().findMessage(varDef.getMessageType());
        int i = 0;
        for (Part part : message.getParts()) {
            if (partName.equals(part.getQName().getLocalPart()))
                return i;
            ++i;
        }
        return -1;
    }

    protected final Object resolveFromPartnerLink(Execution execution) {
        BPELProcessImpl bpelProcess = (BPELProcessImpl) getTopParent();
        PartnerLink partnerLink = bpelProcess.findPartnerLink(getPartnerLink());
        assert partnerLink.getPartnerRole() != null;
        Element serviceRefElement = partnerLink.getValue(execution);
        return serviceRefElement;
    }

    protected final Object resolveFromVariableProperty(Execution execution, String variableName) {
        Scope scope = execution.getCurrentScope();
        Variable variable = scope.findVariable(variableName);
        BPELProcessImpl process = (BPELProcessImpl) getTopParent();
        List<PropertyAlias> propertyAliases = process.getImports().getPropertyAliases();
        List<PropertyAlias> matchingPropertyAliasesFirstFiltering = new ArrayList<PropertyAlias>();
        if (variable instanceof MessageTypeVariable) {
            for (PropertyAlias propertyAlias : propertyAliases) {
                if(propertyAlias.getMessageType().equals(((TVariable)((AbstractSchemaElementImpl)variable).getModel()).getMessageType())) {
                    matchingPropertyAliasesFirstFiltering.add(propertyAlias);
                }
            }
        } else if (variable instanceof ElementVariable) {
            for (PropertyAlias propertyAlias : propertyAliases) {
                if(propertyAlias.getElement().equals(((TVariable)((AbstractSchemaElementImpl)variable).getModel()).getElement())) {
                    matchingPropertyAliasesFirstFiltering.add(propertyAlias);
                }
            }
        } else if(variable instanceof TypeVariable) {
            for (PropertyAlias propertyAlias : propertyAliases) {
                if(propertyAlias.getMessageType().equals(((TVariable)((AbstractSchemaElementImpl)variable).getModel()).getType())) {
                    matchingPropertyAliasesFirstFiltering.add(propertyAlias);
                }
            }
        } else {
            assert false;
        }
        
        QName propertyQName = getProperty();
        List<PropertyAlias> matchingPropertyAliases = new ArrayList<PropertyAlias>();
        for (PropertyAlias propertyAlias : matchingPropertyAliasesFirstFiltering) {
            if (propertyAlias.getQName().equals(propertyQName)) {
                matchingPropertyAliases.add(propertyAlias);
            }
        }
        if (matchingPropertyAliases.size() > 1) {
            throw new CoreException("Too much property alias");
        }
        if (matchingPropertyAliases.isEmpty()) {
            throw new CoreException("No property alias");
        }
        
        PropertyAlias matchingPropertyAlias = matchingPropertyAliases.get(0);
        if (variable instanceof MessageTypeVariable) {
            assert matchingPropertyAlias.getMessageType() != null;
            assert matchingPropertyAlias.getPart() != null;
            String query = matchingPropertyAlias.getQuery() != null ?
                    matchingPropertyAlias.getQuery().getContentString() : "";
            Expression expression = new BPELExpressionImpl("$" + variableName + "." + matchingPropertyAlias.getPart() + "/" + query, this);
            return scope.getExpressionEvaluator().evaluateAsNode(execution, expression);
            
        } else if ((variable instanceof ElementVariable) ||
                (variable instanceof TypeVariable)) {
            assert matchingPropertyAlias.getElement() != null;
            String query = matchingPropertyAlias.getQuery() != null ?
                    matchingPropertyAlias.getQuery().getContentString() : "";
            Expression expression = new BPELExpressionImpl("$" + variableName + "/" + query, this);
            return scope.getExpressionEvaluator().evaluateAsNode(execution, expression);
        } else {
            assert false;
        }
        return null;
    }


}
