/**
* easy BPEL software - Copyright (c) 2009 PetalsLink,
* http://www.petalslink.com/
*
* This library is free software; you can redistribute it and/or modify it under
* the terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; either version 2.1 of the License, or (at your option)
* any later version. This library is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;


public class CopyImpl extends AbstractSchemaElementImpl<TCopy> implements Copy {

	private From from;
	private To to;
	
	public CopyImpl(TCopy model, AbstractSchemaElementImpl parent) {
		super(model, parent);
		this.from = new FromImpl(model.getFrom(), parent);
		this.to = new ToImpl(model.getTo(), parent);
	}

	
	@Override
	public From getFrom() {
		return from;
	}

	@Override
	public void setFrom(From from) {
		this.from = from;
		if(from!=null) {
			this.model.setFrom(((FromImpl)from).getModel());
		}
		else {
			this.model.setFrom(null);
		}
	}

	@Override
	public To getTo() {
		return to;
	}

	@Override
	public void setTo(To to) {
		this.to = to;
		if(to!=null) {
			this.model.setTo(((ToImpl)to).getModel());
		}
		else {
			this.model.setTo(null);
		}
	}

	@Override
	public boolean getKeepSrcElementName() {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public void setKeepSrcElementName(boolean keep) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean getIgnoreMissingFromData() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void setIgnoreMissingFromData(boolean ignore) {
		throw new UnsupportedOperationException();
	}


	
	
	
	@Override
	public QName getTag() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void setTag(QName name) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public List<Element> getOtherElements() throws XmlException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void addOtherElements(Element elmt) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void validate() {
		// TODO Auto-generated method stub
		
	}
	
	
}
