/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDeadlineExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELExpressionImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public class OnAlarmImpl extends BPELElementImpl<TOnAlarmPick> implements OnAlarm {
	
	private static final long serialVersionUID = 1L;
	private Activity activity;
	private BPELExpression _for;
	private BPELExpression until;
	
	public OnAlarmImpl(final TOnAlarmPick model, final BPELElementImpl<?> parent) {
		super(Constants._OnAlarm_QNAME, model, parent);
		
		try {
			this.activity = ActivityImpl.analyzeOnAlarmActivity(this.model, this);
		} catch (final BPELException e) {
			final Pick pick = (Pick) this.getParent();
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In a onAlarm of pick " + pick.getName() + " => " + e.getMessage(), e)));
		}
		if(model.getFor()!=null) {
			_for = new BPELExpressionImpl(model.getFor(), this);
		}
		if(model.getUntil()!=null) {
			until = new BPELExpressionImpl(model.getUntil(), this);
		}
		
	}

	@Override
	public Activity getActivity() {
		return activity;
	}

	@Override
	public void setActivity(Activity a) {
		this.activity = a;
		try {
			ActivityImpl.setActivityToOnAlarm(a, this);
		} catch (BPELException e) {
			throw new UncheckedException(e);
		}
	}
	
	@Override
	public BPELExpression getFor() {
		return _for;
	}

	@Override
	public BPELExpression getUntil() {
		return until;
	}

	@Override
	public void setFor(BPELExpression e) {
		_for = e;
		this.model.setFor((TDurationExpr) ((AbstractSchemaElementImpl<?>)e).getModel());
	}

	@Override
	public void setUntil(BPELExpression e) {
		until = e;
		this.model.setUntil((TDeadlineExpr) ((AbstractSchemaElementImpl<?>)e).getModel());
	}

}
