/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnMessageValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class OnMessageValidatorImpl implements OnMessageValidator {

	private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());

	private OnMessage message = null;

	public OnMessageValidatorImpl(final OnMessage onMessage) {
		this.message = onMessage;
	}

	public void validate() {

		// validation
		log.finest("validate onMessage");

		// unsupported element

			if((((TOnMessage)((BPELElementImpl)this.message).getModel()).getFromParts() != null) && (((TOnMessage)((BPELElementImpl)this.message).getModel()).getFromParts().getFromPart().size() > 0)) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead"));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the activity fromPart is not supported by BPEL engine for the moment. Use assign element after this receive instead")));
			}
			if(((TOnMessage)((BPELElementImpl)this.message).getModel()).getMessageExchange() != null) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.message, "In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment."));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => [BPEL engine Restriction] Sorry, but the messageExchange attribute is not supported by BPEL engine for the moment.")));
			}

			// validation if null or empty
			if((this.message.getPartnerLink() == null) || (this.message.getPartnerLink().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the partnerLink cannot be null or empty")));
			}
			if((this.message.getOperation() == null) || (this.message.getOperation().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the operation cannot be null or empty")));
			}
			if((this.message.getInputVariable() == null) || (this.message.getInputVariable().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => the input variable cannot be null or empty")));
			}

			// validation if exist

			// find partnerLink
			if((this.message.getPartnerLink() != null) && (this.message.getPartnerLink().trim().length() > 0)) {
				final PartnerLink partnerLink = ScopeUtil.findPartnerLinkRecursively(this.message.getPartnerLink(), (BPELElement) ((BPELElementImpl)this.message).getParent());
				if(partnerLink == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find partnerLink corresponding to the name: " + this.message.getPartnerLink())));
				}

				// find operation
				if((this.message.getOperation() != null) && (this.message.getOperation().trim().length() > 0)) {
					if(partnerLink != null) {
						final BPELProcess process = ScopeUtil.getProcess((this.message));

						final List<Interface> itfsToVerify = new ArrayList<Interface>();
						if(this.message.getInterface() != null) {
							final Interface itf = process.getImports().findInterface(this.message.getInterface());
							if(itf != null) {
								itfsToVerify.add(itf);
							}
						} else {
							final PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
							if(((partnerLink.getMyRole() == null) || (partnerLink.getMyRole().trim().length() == 0))&&
									((partnerLink.getPartnerRole() == null) || (partnerLink.getPartnerRole().trim().length() == 0))) {
								// get all role of partnerLink type
								for(final Role r: plt.getRoles()) {
                                    Interface itf = process.getImports().findInterface(r.getInterfaceQName());
									if(itf == null) {
										BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
									}
									if(itf != null) {
										itfsToVerify.add(itf);
									}
								}
							} else {
								if((partnerLink.getMyRole() != null) && (partnerLink.getMyRole().trim().length() > 0)) {
									for(final Role r: plt.getRoles()) {
	                                    Interface itf = process.getImports().findInterface(r.getInterfaceQName());
										if(itf == null) {
											BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
										}
										if(r.getName().equals(partnerLink.getMyRole()) && itf != null) {
											itfsToVerify.add(itf);
											break;
										}
									}
								} 
								if((partnerLink.getPartnerRole() != null) && (partnerLink.getPartnerRole().trim().length() > 0)) {
									for(final Role r: plt.getRoles()) {
										if(r.getName().equals(partnerLink.getPartnerRole())) {
	                                        Interface itf = process.getImports().findInterface(r.getInterfaceQName());
											itfsToVerify.add(itf);
											break;
										}
									}
								}
							}
						}
						final List<Operation> ops = new ArrayList<Operation>();
						if(itfsToVerify.size() == 0) {
							if(this.message.getInterface() != null) {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the portType: " + this.message.getInterface())));
							} else {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find portType. You must add portType attribute in receive or add a role to the partnerLink of receive")));
							}
						}

						for(final Interface itf: itfsToVerify) {
							final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.message.getOperation()));
							if(op != null) {
								ops.add(op);
							}
						}

						if(ops.size() == 0) {
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find in wsdl descriptions the operation: " + this.message.getOperation())));
						} else if(ops.size() > 1) {
							String itfString = null;
							for(final Operation op: ops) {
								if(itfString == null) {
									itfString = op.getParentInterface().getQName().toString();
								} else {
									itfString = itfString + ", " + op.getParentInterface().getQName().toString();
								}
							}
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Several interfaces match with the operation " + this.message.getOperation() + ": " + itfString + ". " +  "You must add portType attribute in receive or add a role to the partnerLink of receive")));
						}

					}



				}

			}

			// find variable
			if((this.message.getInputVariable() != null) && (this.message.getInputVariable().trim().length() > 0)) {
				final Variable var = ScopeImpl.findVariableRecursively(this.message.getInputVariable(), (BPELElement) ((BPELElementImpl)this.message).getParent());
				if(var == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.message, new BPELException("In OnMessage => Impossible to find input variable corresponding to the name: " + this.message.getInputVariable())));
				}
			}
	}

}
