/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.XMLElement;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.AbstractValidatorManagerImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ValidatorManager;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class ValidatorManagerImpl extends AbstractValidatorManagerImpl implements ValidatorManager {

	private static Logger log = Logger.getLogger(ValidatorManagerImpl.class.getName());


	public static ValidatorManager getInstance() {
		if(instance == null) {
			instance = new ValidatorManagerImpl();
		}
		return instance;
	}



	public void validate(final BPELElement elmt) {
		if(elmt != null) {
			if(elmt instanceof BPELProcess) {
				new ProcessValidatorImpl((BPELProcess) elmt).validate();
			} else if(elmt instanceof Scope) {
				new ScopeValidatorImpl((Scope) elmt).validate();
			} else if(elmt instanceof Import) {
				new ImportValidatorImpl((Import) elmt).validate();
			} else if(elmt instanceof PartnerLink) {
				new PartnerLinkValidatorImpl((PartnerLink) elmt).validate();
			} else if(elmt instanceof Extensions) {
				new ExtensionsValidatorImpl((Extensions) elmt).validate();
			} else if(elmt instanceof Extension) {
				new ExtensionValidatorImpl((Extension) elmt).validate();
			} else if(elmt instanceof Variable) {
				new VariableValidatorImpl((Variable) elmt).validate();
			} else if(elmt instanceof CorrelationSet) {
				new CorrelationSetValidatorImpl((CorrelationSet) elmt).validate();
			} else if(elmt instanceof Correlation) {
				new CorrelationValidatorImpl((Correlation) elmt).validate();
			} else if(elmt instanceof FaultHandlers) {
				new FaultHandlersValidatorImpl((FaultHandlers) elmt).validate();
			} else if(elmt instanceof Catch) {
				new CatchValidatorImpl((Catch) elmt).validate();
			} else if(elmt instanceof Throw) {
				new ThrowValidatorImpl((Throw) elmt).validate();
			} else if(elmt instanceof Receive) {
				new ReceiveValidatorImpl((Receive) elmt).validate();
			} else if(elmt instanceof Reply) {
				new ReplyValidatorImpl((Reply) elmt).validate();
			} else if(elmt instanceof Invoke) {
				new InvokeValidatorImpl((Invoke) elmt).validate();
			} else if(elmt instanceof Wait) {
				new WaitValidatorImpl((Wait) elmt).validate();
			} else if(elmt instanceof Empty) {
				new EmptyValidatorImpl((Empty) elmt).validate();
			} else if(elmt instanceof Sequence) {
				new SequenceValidatorImpl((Sequence) elmt).validate();
			} else if(elmt instanceof If) {
				new IfValidatorImpl((If) elmt).validate();
			} else if(elmt instanceof While) {
				new WhileValidatorImpl((While) elmt).validate();
			} else if(elmt instanceof RepeatUntil) {
				new RepeatUntilValidatorImpl((RepeatUntil) elmt).validate();
			} else if(elmt instanceof ForEach) {
				new ForEachValidatorImpl((ForEach) elmt).validate();
			} else if(elmt instanceof Pick) {
				new PickValidatorImpl((Pick) elmt).validate();
			} else if(elmt instanceof OnMessage) {
				new OnMessageValidatorImpl((OnMessage) elmt).validate();
			}  else if(elmt instanceof OnAlarm) {
				new OnAlarmValidatorImpl((OnAlarm) elmt).validate();
			} else if(elmt instanceof Flow) {
				new FlowValidatorImpl((Flow) elmt).validate();
			} else if(elmt instanceof Exit) {
				new ExitValidatorImpl((Exit) elmt).validate();
			} else if(elmt instanceof ReThrow) {
				new ReThrowValidatorImpl((ReThrow) elmt).validate();
			} else if(elmt instanceof Assign) {
				new AssignValidatorImpl((Assign) elmt).validate();
			} else if(elmt instanceof Copy) {
				new CopyValidatorImpl((Copy) elmt).validate();
			} else if(elmt instanceof From) {
				new FromValidatorImpl((From) elmt).validate();
			} else if(elmt instanceof To) {
				new ToValidatorImpl((To) elmt).validate();
			} else if(elmt instanceof ExtensionActivity) {
				new ExtensionActivityValidatorImpl((ExtensionActivity) elmt).validate();
			} else {
				log.warning("this BPLElement " + elmt.getClass() + " has no validator");
			}
		}
	}



	public void validate(XMLElement elmt) {
		if(elmt != null) {
			if(elmt instanceof ExtendedActivity) {
				((ExtendedActivity)elmt).validate((BPELStaticAnalysis)BPELStaticAnalysisImpl.getInstance());
			} else {
				log.warning("this XMLElement " + elmt.getClass() + " has not validator");
			}
		}
	}

}
