/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELReaderImpl implements
com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader {


	private static Logger log = Logger.getLogger(BPELReaderImpl.class.getName());


	private Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();


	/*
	 * Private object initializations
	 */
	public BPELReaderImpl() throws BPELException {
		try {
			this.features.put(FeatureConstants.VERBOSE, false);
			this.features.put(FeatureConstants.IMPORT_DOCUMENTS, true);

			BPELJAXBContext.getInstance();

		} catch (final BPELException e) {
			throw new BPELException(e);
		}
	}

	
    
    public JAXBContext getJaxbContext() throws BPELException {
    	return BPELJAXBContext.getInstance().getJaxbContext();
    }

	/**
	 * Build the Java bindings from the WSDL descriptor in XML form. The
	 * validation against the WSDL schema is processed during the
	 * transformation.
	 * 
	 * @param AgreementDescriptorStream
	 *            The Agreement descriptor in XML form
	 * @return The root object of the EndpointReference descriptor
	 * @throws BPELException
	 *             The exception raised during the unmarshaller creation or the
	 *             exception raised during the build of the java bindings.
	 */
	private TProcess convertStream2Process(final Source bpelDescriptorStream)
	throws BPELException {

		try {
			final JAXBElement<TProcess> wsdlBinding = this.getJaxbContext().createUnmarshaller()
			.unmarshal(bpelDescriptorStream, TProcess.class);

			return wsdlBinding.getValue();

		} catch (final JAXBException e) {
			throw new BPELException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
	}



	public BPELProcess readBPEL(final URI wsdlURI) throws BPELException {
		BPELProcess desc = null;
		try {
			InputStream input = null;

			final File f = new File(wsdlURI.toString());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = wsdlURI.toURL().openStream();
			}
			desc = this.readBPEL(wsdlURI, new InputSource(input));
		} catch (final MalformedURLException e) {
			throw new BPELException("Can not get bpel at: " + wsdlURI, e);
		} catch (final IOException e) {
			throw new BPELException("Can not get bpel at: " + wsdlURI, e);
		} catch (final BPELException e) {
			throw new BPELException("Can not get bpel at: " + wsdlURI, e);
		} catch (final IllegalArgumentException e) {
			throw new BPELException("Can not get bpel at: " + wsdlURI, e);
		} 
		return desc;
	}

	public BPELProcess readBPEL(final Document bpelDocument) throws BPELException {
		BPELProcess desc = null;
		try {
			URI uri = null;
			if(bpelDocument.getDocumentURI() != null) {
				uri = new URI(bpelDocument.getDocumentURI());
			} else {
				uri = new File(".").toURI();
			}
			desc = this.readBPEL(uri,
					SourceHelper.convertDOMSource2InputSource(new DOMSource(bpelDocument)));
		} catch (final URISyntaxException e) {
			throw new BPELException(e);
		} catch (final XmlException e) {
			throw new BPELException(e);
		}
		return desc;
	}

	public BPELProcess readBPEL(final URI wsdlURI, final InputSource inputSource)
	throws BPELException {
		BPELProcess desc = null;
		try {
			
			log.finest("Loading " + wsdlURI);
			final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			final EasyNSFilter filter = new EasyNSFilter(xmlReader);
			final SAXSource saxSource = new SAXSource(filter, inputSource);
			
			final TProcess def = this.convertStream2Process(saxSource);


			desc = new com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl(wsdlURI, def, filter.getNamespaceMapper(), this.getFeatures());
		} catch (final SAXException e) {
			throw new BPELException(e);
		}
		return desc;
	}


	public final void setFeature(final FeatureConstants name, final Object value)
	throws BPELException {
		this.features.put(name, value);
		BPELReaderImpl.log.finest("set proterty: " + name + " - value = " + value);
	}

	public final Object getFeature(final FeatureConstants name) {
		return this.features.get(name);
	}

	public final Map<FeatureConstants, Object> getFeatures() {
		return this.features;
	}

	public final void setFeatures(final Map<FeatureConstants, Object> features) {
		this.features = features;
	}

}
