/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */

package com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink;

import java.util.Collection;
import java.util.List;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XmlException;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLinks;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.PartnerEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class PartnerLinkImpl extends BPELElementImpl<TPartnerLink> implements PartnerLink {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private final TPartnerLinks parent;

    public PartnerLinkImpl(final TPartnerLink model, final TPartnerLinks parent,
            final BPELElement scopeDefinition) {
        super(Constants._PartnerLink_QNAME, model, scopeDefinition);
        this.parent = parent;
    }

    public Boolean getInitializePartnerRole() {
        Boolean res = null;
        if (this.model.getInitializePartnerRole() != null) {
            res = Boolean.valueOf(this.model.getInitializePartnerRole().value);
        }
        return res;
    }

    public String getMyRole() {
        return this.model.getMyRole();
    }

    public String getName() {
        String res = null;
        if (this.model != null) {
            res = this.model.getName();
        }
        return res;
    }

    public QName getPartnerLinkType() {
        return this.model.getPartnerLinkType();
    }

    public String getPartnerRole() {
        return this.model.getPartnerRole();
    }

    public void setInitializePartnerRole(final Boolean value) {
        if (value == null) {
            this.model.setInitializePartnerRole(null);
        } else if (value.booleanValue() == true) {
            this.model.setInitializePartnerRole(TBoolean.YES);
        } else {
            this.model.setInitializePartnerRole(TBoolean.NO);
        }
    }

    public void setMyRole(final String value) {
        this.model.setMyRole(value);
    }

    public void setName(final String value) {
        this.model.setName(value);
    }

    public void setPartnerLinkType(final QName value) {
        this.model.setPartnerLinkType(value);
    }

    public void setPartnerRole(final String value) {
        this.model.setPartnerRole(value);
    }

    @Override
    public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
        throw new UnsupportedOperationException();
    }

    public TPartnerLinks getPartnerLinks() {
        return this.parent;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Element getValue(Execution execution) {
        return execution.getPartnerValue(getName());
    }

    @Override
    public void initialize(Execution execution) {
        Scope scope = execution.getCurrentScope();
        PartnerEvaluator partnerEvaluator = scope.getPartnerEvaluator();
        BPELProcessImpl bpelprocess = (BPELProcessImpl) getTopParent();

        PartnerLinkType partnerLinkType = bpelprocess.getImports().getPartnerLinkType(
                getPartnerLinkType());
        assert partnerLinkType != null;
        
        Role role = partnerLinkType.getRole(getPartnerRole() != null ? 
                getPartnerRole() : getMyRole());

        assert role != null;
        QName interfaceName = role.getInterfaceQName();
        assert interfaceName != null;
        Interface itf = bpelprocess.getImports().findInterface(interfaceName);
        Collection<org.petalslink.abslayer.service.api.Endpoint> endpoints = bpelprocess
                .getImports().findEndpointsImplementingInterface(itf);
        if (!endpoints.isEmpty()) {
            org.petalslink.abslayer.service.api.Endpoint firstPossibleEndpoint = endpoints
                    .iterator().next();
            Element element = partnerEvaluator.createElement(firstPossibleEndpoint.getService().getQName(), 
                    firstPossibleEndpoint.getName());
            execution.putPartnerValue(getName(), element);
        } else {
            execution.putPartnerValue(getName(), partnerEvaluator.createEmptyElement());
        }
    }

    @Override
    public void assign(Execution execution, Object value) {
        // this method should not be used anymore.
        assert false;
//        assert value instanceof Element;
//        execution.assignPartnerValue(getName(), (Element) value);
    }

}
