/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink,
 * http://www.petalslink.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.TechnicalException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SoapBindingInputMessageAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SoapBindingOutputMessageAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter.Direction;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;

public class BPELFaultHandler implements FaultHandler {
    private Logger log = Logger.getLogger(BPELFaultHandler.class.getName());

    private final Descriptions desc;

    private final BPELProcess bpeldefinition;

    private final Invoke invoke;

    public BPELFaultHandler(final BPELProcess bpeldefinition, final Invoke invoke) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.invoke = invoke;
    }

    public void assignExceptionVariable(Execution execution, CoreException exception, 
            Variable variable) throws CoreException {
        assert exception instanceof UserDefinedException;
        UserDefinedException businessException = (UserDefinedException) exception; 
        SoapBindingInputMessageAdapter soapBindingInputAdapter = new SoapBindingInputMessageAdapter(
                this.bpeldefinition);
        SoapBindingOutputMessageAdapter soapBindingOutputAdapter = new SoapBindingOutputMessageAdapter(
                this.bpeldefinition);

        final Element detail = soapBindingOutputAdapter
                .getDetails((Element) businessException.getFault().getBody()
                        .getPayload());
        final Document doc = new Document(
                (Element) (Util.getChildElements(detail).get(0)).clone());
        final Message faultMessage = new MessageImpl(businessException.getFault()
                .getOperationName());
        faultMessage.getBody().setPayload(doc.getRootElement());
        faultMessage.setEndpoint(businessException.getFault().getEndpoint());
        faultMessage.setQName(businessException.getFault().getQName());
        faultMessage.setService(businessException.getFault().getService());
        
        soapBindingInputAdapter.adaptFromBindingInput(execution, faultMessage, variable,
                businessException.getDirection(),
                businessException.getIsBindingStyleRpc());
    }

    
    @SuppressWarnings("unchecked")
    public boolean match(Execution execution, final Fault f, final CoreException e,
            final Scope faultScope) throws CoreException {
//        SoapBindingInputMessageAdapter soapBindingInputAdapter = new SoapBindingInputMessageAdapter(
//                this.bpeldefinition);
//        SoapBindingOutputMessageAdapter soapBindingOutputAdapter = new SoapBindingOutputMessageAdapter(
//                this.bpeldefinition);

        boolean res = false;
        try {
            if ((f.getFaultName() != null) && f.getFaultName().getLocalPart().equals("unknown")
                    && (f.getVariable() == null)) {
                this.log.finest("faultName = " + f.getFaultName());
                res = true;
            } else if (e instanceof UserDefinedException) {
                UserDefinedException businessException = (UserDefinedException) e;
                final Variable var = f.getVariable();
                TVariable varDef = ((AbstractSchemaElementImpl<TVariable>) var).getModel();
                if (!res
                        && (var instanceof ElementVariable)
                        && (businessException.getQnameType() == UserDefinedException.FaultQnameType.ELEMENT_QNAME)
                        && varDef.getElement().equals(
                                businessException.getMessageTypeOrElementQName())) {
                    res = true;

                    // if (businessException.getFault() == null) {
                    // final Variable vf =
                    // faultScope.findVariable(businessException.getFaultVariableName());
                    // MessageImpl variableMessage = new
                    // MessageImpl("dummyOperation");
                    // variableMessage.getBody().setPayload((Element)
                    // vf.getValue(execution));
                    //
                    // final Message formattedSoapFault = (Message)
                    // (soapBindingOutputAdapter)
                    // .formatFault(variableMessage);
                    // final Element soapFault = SoapBindingOutputMessageAdapter
                    // .createSOAPFault(formattedSoapFault.getBody().getPayload());
                    // final Message faultSoap = new
                    // MessageImpl("dummyOperation");
                    // faultSoap.getBody().getPayload().setContent(soapFault);
                    // businessException.setFault(faultSoap);
                    // }

                    // final Variable v =
                    // faultScope.findVariable(varDef.getName());
                    //
                    // final Element detail = soapBindingOutputAdapter
                    // .getDetails(businessException.getFault().getBody().getPayload());
                    //
                    // final Document doc = new Document(
                    // (Element)
                    // (Util.getChildElements(detail).get(0)).clone());
                    //
                    //
                    // final Message faultMessage = new
                    // MessageImpl(((UserDefinedException) e)
                    // .getFault().getOperationName());
                    //
                    // faultMessage.getBody().setPayload(doc.getRootElement());
                    // faultMessage.setEndpoint(((UserDefinedException)
                    // e).getFault().getEndpoint());
                    // faultMessage.setQName(((UserDefinedException)
                    // e).getFault().getQName());
                    // faultMessage.setService(((UserDefinedException)
                    // e).getFault().getService());
                    //
                    // soapBindingInputAdapter.adaptFromBindingInput(execution,
                    // faultMessage, v,
                    // businessException.getDirection(),
                    // businessException.getIsBindingStyleRpc());

                } else if (!res
                        && (var instanceof MessageTypeVariable)
                        && (businessException.getQnameType() == UserDefinedException.FaultQnameType.MESSAGE_QNAME)
                        && varDef.getMessageType().equals(
                                businessException.getMessageTypeOrElementQName())) {

                    res = true;

                    // if (businessException.getFault() == null) {
                    // final Variable vf =
                    // faultScope.findVariable(businessException
                    // .getFaultVariableName());
                    // MessageImpl variableMessage = new
                    // MessageImpl("dummyOperation");
                    // variableMessage.getBody().setPayload((Element)
                    // vf.getValue(execution));
                    //
                    // final Message formattedSoapFault = (Message)
                    // (soapBindingOutputAdapter)
                    // .formatFault(variableMessage);
                    // final Element soapFault = SoapBindingOutputMessageAdapter
                    // .createSOAPFault(formattedSoapFault.getBody().getPayload());
                    // final Message faultSoap = new
                    // MessageImpl("dummyOperation");
                    // faultSoap.getBody().setPayload(soapFault);
                    //
                    // businessException.setFault(faultSoap);
                    // }

                    //
                    // List<Element> partsElements = ((Element)
                    // faultMessage.getBody().getPayload())
                    // .getChildren();
                    // v.assign(partsElements.toArray(new
                    // Element[partsElements.size()]));
                }
            }

            if (!res && (f.getFaultName() != null)
                    && f.getFaultName().toString().equals(((CoreException) e).getName())) {
                res = true;
            }
            if (!res && (f.getVariable().getName() != null)
                    && f.getVariable().getName().toString().equals(((CoreException) e).getName())) {
                res = true;
            }
        } catch (final BPELException ex) {
            throw new CoreException(e);
        }
        return res;
    }

    private static final String findRelevantMessage(Throwable t) {
        assert t != null;
        // TODO : this function is really a hack ; exception handling in BPEL is
        // clumsy
        // and would need a massive refactoring to prevent wrapping of wrapping
        // of
        // wrapping of meaningless CoreException...
        String message = t.getMessage();
        if (message == null) {
            if (t.getCause() != null) {
                return findRelevantMessage(t.getCause());
            }
            return null;
        } else {
            return message;
        }
    }

    public BPELException getBPELExceptionFromGenericException(final Scope scope,
            final CoreException e, BindingMessageAdapter.Direction direction,
            boolean isBindingStyleRpc) throws CoreException {
        SoapBindingOutputMessageAdapter soapBindingOutputAdapter = new SoapBindingOutputMessageAdapter(
                this.bpeldefinition);

        BPELException res = null;
        assert (e instanceof CoreException);
        CoreException ce = (CoreException) e;
        assert this.invoke != null;
        assert this.bpeldefinition != null;
        final Message fault = e.getFault();
        if (fault == null) {
            throw new CoreException(findRelevantMessage(ce), ce);
        }

        final Element details = soapBindingOutputAdapter.getDetails(((Message) fault).getBody()
                .getPayload());
        if ((details != null) && (details.getChildren().size() > 1)) {
            throw new CoreException("Sorry, but the management of severals faults is not supported");
        }

        if ((details != null) && (Util.getChildElements(details).size() == 1)) {
            final Element elmt = Util.getChildElements(details).get(0);
            final QName faultElement = new QName(elmt.getNamespaceURI(), elmt.getName());
            final QName interfaceName = this.invoke.getInterface();
            Interface itf = null;
            if (interfaceName != null) {
                itf = this.desc.findInterface(interfaceName);
            } else {
                PartnerLink partnerLink = bpeldefinition.findPartnerLink(this.invoke
                        .getPartnerLink());
                PartnerLinkType partnerLinkType = null;
                partnerLinkType = bpeldefinition.getImports().getPartnerLinkType(
                        partnerLink.getPartnerLinkType());
                Role partnerLinkRole = partnerLinkType.getRole(partnerLink.getPartnerRole());
                itf = bpeldefinition.getImports()
                        .findInterface(partnerLinkRole.getInterfaceQName());
            }
            if (itf == null) {
                throw new CoreException("Impossible to find interface '" + interfaceName + "'.");
            }
            final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(),
                    this.invoke.getOperation()));
            if (op == null) {
                throw new CoreException("Impossible to find operation with this name: "
                        + this.invoke.getOperation());
            }
            final org.petalslink.abslayer.service.api.Fault[] faults = op.getFaults();
            for (final org.petalslink.abslayer.service.api.Fault faultDef : faults) {
                final QName faultName = new QName(itf.getQName().getNamespaceURI(),
                        faultDef.getName());
                // CAUTION : message name must be tested first!! easywsdl
                // assimilate Element taken from
                // message part and element got by resolving its qname ; so if
                // messageName is set, element
                // will ALWAYS be set too...
                if ((faultDef.getMessageName() != null)
                        && ((faultName.equals(faultElement) || ((faultDef.getElementQName() != null) && faultDef
                                .getElementQName().equals(faultElement))))) {
                    this.log.finest("Creating new UserDefinedException from message");
                    res = new UserDefinedException(faultName, null,
                            UserDefinedException.FaultQnameType.MESSAGE_QNAME,
                            faultDef.getMessageName(), scope);
                    res.setName(faultName.toString());
                    res.setFault(fault);
                    break;
                } else if ((faultDef.getElementQName() != null)
                        && (faultDef.getElementQName().equals(faultElement))) {
                    this.log.finest("Creating new UserDefinedException from element");
                    res = new UserDefinedException(faultName, null,
                            UserDefinedException.FaultQnameType.ELEMENT_QNAME,
                            faultDef.getElementQName(), scope);
                    res.setName(faultName.toString());
                    res.setFault(fault);
                    break;
                }
            }
        } else {
            res = new TechnicalException(ce);
        }
        res.setDirection(direction);
        res.setIsBindingStyleRpc(isBindingStyleRpc);
        return res;
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }
}
