
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.TypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.SelectionFailureException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.AbstractVariableImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.GetVariablePropertyFunction;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class ExpressionEvaluatorImpl implements ExpressionEvaluator {

    private final BPELProcess bpelProcess;
    private final Scope scope;

    public ExpressionEvaluatorImpl(BPELProcess bpelProcess, Scope scope) {
        this.bpelProcess = bpelProcess;
        this.scope = scope;

    }

    @Override
    public boolean evaluateAsBoolean(Execution execution, Expression expression) {
        try {
            XPath xpath = createXPath(execution, expression);
            return xpath.booleanValueOf(null);
        } catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    @Override
    public int evaluateAsInteger(Execution execution, Expression expression) {
        try {
            XPath xpath = createXPath(execution, expression);
            return xpath.numberValueOf(null).intValue();
        } catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    @Override
    public String evaluateAsString(Execution execution, Expression expression) {
        try {
            XPath xpath = createXPath(execution, expression);
            return xpath.stringValueOf(null);
        } catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    @Override
    public Object evaluateAsNode(Execution execution, Expression expression) {
        return evaluateAsNode(execution, expression, null);
    }
    
    
    @Override
    public Object evaluateAsNode(Execution execution, Expression expression, Object contextNode) {
        try {
            System.err.println("XPATH = " + expression.getContent());
            XPath xpath = createXPath(execution, expression);
            Object result = xpath.selectSingleNode(contextNode);
            System.err.println("XPATH RESULT = " + result);
            return result;
        } catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    
    @SuppressWarnings("unchecked")
    private final XPath createXPath(Execution execution, Expression expression) {
        
        XPathFunctionContext functionContext = new XPathFunctionContext();
        functionContext.registerFunction(Constants.BPEL_20_EXECUTABLE_NAMESPACE, 
                "doXslTransform", new DoXslTransformFunction(bpelProcess.getDocumentBaseURI()));
        functionContext.registerFunction(Constants.BPEL_20_EXECUTABLE_NAMESPACE, 
                "getVariableProperty", new GetVariablePropertyFunction(execution));
        
        SimpleVariableContext variableContext = new SimpleVariableContext();
        XPath xpath;
        try {
            xpath = new JDOMXPath(expression.getContent());
        } catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }

        // TODO : add custom functions
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        BPELProcessImpl bpelProcess = findBpelProcess(expression);
        if (bpelProcess != null) {
            for (Description desc : bpelProcess.getImports().getDescriptions()) {
                for (Map.Entry<String, String> namespaceBinding :
                    desc.getNamespaces().entrySet()) {
//                    System.err.println("::" + namespaceBinding.getKey() + "=" + namespaceBinding.getValue());
                    namespaceContext.addNamespace(namespaceBinding.getKey(), namespaceBinding.getValue());
                }
            }
            Map<String, String> namespaceBindings = bpelProcess.getNamespaceContext().getNamespaces();
            for (Map.Entry<String, String> namespaceBinding : namespaceBindings.entrySet()) {
//                System.err.println("!!" + namespaceBinding.getKey() + "=" + namespaceBinding.getValue());
                namespaceContext.addNamespace(namespaceBinding.getKey(), namespaceBinding.getValue());
            }
        }
        
        if (scope != null) {
            
            Map<String, Variable> variables = scope.getInScopeVariables();
            for (Map.Entry<String, Variable> entry : variables.entrySet()) {
                String variableName = entry.getKey();
                assert variableName != null;
                Variable bpelVariable = entry.getValue();
                System.err.println("-*-*- DECL var " + bpelVariable.getName());
                
                if (bpelVariable instanceof MessageTypeVariable) {
                    // if variable is a message, each part of message must be
                    // declared in context...
                    MessageTypeVariable messageTypeVariable = (MessageTypeVariable) bpelVariable;

                    Element rootMessageElement = messageTypeVariable.getValue(execution);
                    Part[] parts = retrievePartsFromMessageElement((AbstractVariableImpl) bpelVariable);
                    List<Element> children = (List<Element>) rootMessageElement.getChildren();
                    assert children.size() == parts.length;

                    int i = 0;
                    for (Element partElement : children) {

                        // declare element namespace
                        if (!partElement.getNamespacePrefix().isEmpty()) {
                            namespaceContext.addNamespace(partElement.getNamespacePrefix(),
                                    partElement.getNamespaceURI());
                        }
                        // declare additional namespaces in namespace context...
                        for (Namespace additionalNamespace : (List<Namespace>) partElement
                                .getAdditionalNamespaces()) {
                            namespaceContext.addNamespace(additionalNamespace.getPrefix(),
                                    additionalNamespace.getURI());
                        }

                        String partName = parts[i].getQName().getLocalPart();
                        String partVariableName = variableName + "." + partName;
                        
                        declareVariableInVariableContext(partVariableName, partElement, variableContext);
                        ++i;
                    }
                } else if (bpelVariable instanceof ElementVariable) {
                    // if variable is a element, variable is directly declared in context
                    Element variableValue = ((ElementVariable) bpelVariable).getValue(execution);
                    declareVariableInVariableContext(variableName, variableValue, variableContext);
                } else if (bpelVariable instanceof TypeVariable) {
                    Object variableValue = ((TypeVariable) bpelVariable).getValue(execution);
                    declareVariableInVariableContext(variableName, variableValue, variableContext);

                } else {
                    assert false;
                }
            }
        }
        xpath.setNamespaceContext(namespaceContext);
        xpath.setVariableContext(variableContext);
        xpath.setFunctionContext(functionContext);
        return xpath;

    }

    
    private void declareVariableInVariableContext(String variableName, Object variableValue,
            SimpleVariableContext variableContext) {
//        System.err.println("************ " + variableName);
//        if (variableValue instanceof Element) {
//            try {
//                new XMLOutputter(Format.getPrettyFormat()).output((Element) variableValue, System.err);
//                System.err.println("");
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
//            
//        } else if (variableValue instanceof Text){
//            System.err.println(variableValue);
//            
//        }
        variableContext.setVariableValue(variableName, variableValue);
    }

    @SuppressWarnings("rawtypes")
    private final BPELProcessImpl findBpelProcess(Expression expression) {
        assert expression != null;
        AbstractSchemaElementImpl<?> elementImpl = (AbstractSchemaElementImpl) expression;
        if (!(elementImpl.getTopParent() instanceof BPELProcessImpl)) return null;
        BPELProcessImpl bpelProcess = (BPELProcessImpl) elementImpl.getTopParent();
        return bpelProcess;
    }

    private static final Part[] retrievePartsFromMessageElement(AbstractVariableImpl bpelVariable) {
        TVariable varDef = ((AbstractSchemaElementImpl<TVariable>) bpelVariable).getModel();
        // find message definition in process imported WSDLs
        BPELProcessImpl bpelProcess = (BPELProcessImpl) bpelVariable.getTopParent();
        Message message = bpelProcess.getImports().findMessage(varDef.getMessageType());
        return message.getParts();
    }

}
