
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.Namespace;

import com.ebmwebsourcing.easyviper.core.api.engine.PartnerEvaluator;

public class PartnerEvaluatorImpl implements PartnerEvaluator {

    public PartnerEvaluatorImpl() {
    }

    private static final String generateLogicalAddress(QName serviceName, String endpointName) {
        String address = "esb://";
        address = address + serviceName.getNamespaceURI();
        address = address + "::" + serviceName.getLocalPart();
        address = address + "@" + endpointName;
        return address;
    }

    private static final boolean isLogicalAddress(String address) {
        return address.startsWith("esb://") && address.contains("@") && address.contains("::");
    }


    @Override
    public Element createEmptyElement() {
        return new Element("service-ref",
                Namespace.getNamespace("http://docs.oasis-open.org/wsbpel/2.0/serviceref"));   
    }
    
    
    @Override
    public Element createElement(QName serviceName, String endpointName) {
        Element serviceRefElement = createEmptyElement();
        Element eprElement = new Element("EndpointReference",
                Namespace.getNamespace("http://www.w3.org/2005/08/addressing"));
        Element wsaElement = new Element("Address",
                Namespace.getNamespace("http://www.w3.org/2005/08/addressing"));

        wsaElement.addContent(generateLogicalAddress(serviceName, endpointName));
        eprElement.addContent(wsaElement);
        serviceRefElement.addContent(eprElement);

        return serviceRefElement;
    }

    private static final boolean isServiceRefElement(Element element) {
        return "http://docs.oasis-open.org/wsbpel/2.0/serviceref".equals(element.getNamespaceURI())
                && "service-ref".equals(element.getName());
    }

    @Override
    public String getAddress(Element element) {
        assert isServiceRefElement(element);
        if (element.getChildren().isEmpty()) return null;
        Element eprElement = (Element) element.getChildren().get(0);
        Element wsaElement = eprElement.getChild("Address",
                Namespace.getNamespace("http://www.w3.org/2005/08/addressing"));
        if (wsaElement == null) return null;
        return wsaElement.getText().trim();
    }

    @Override
    public QName getServiceName(Element element) {
        String address = getAddress(element);
        if (address == null) return null;
        assert isLogicalAddress(address);
        return getServiceNameFromAddress(address);
    }
    
    
    public static QName getServiceNameFromAddress(String address) {
    	address = address.toString().replace("esb://", "");
        String serviceNamespace = address.substring(0, address.indexOf("::"));
        String serviceLocalPart = address.substring(address.indexOf("::") + "::".length(),
                address.indexOf("@"));
        return new QName(serviceNamespace, serviceLocalPart);
    }

    @Override
    public String getEndpointName(Element element) {
        String address = getAddress(element);
        if (address == null) return null;
        assert isLogicalAddress(address);
        return getEndpointNameFromAddress(address);
    }
    
    public static String getEndpointNameFromAddress(String address) {
    	address = address.toString().replace("esb://", "");
        String endpointName = address.substring(address.indexOf("@") + "@".length(),
                address.length());
        return endpointName;
    }
    
}
