/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */

package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Binding.BindingStyle;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

public class SoapBindingInputMessageAdapter implements BindingInputMessageAdapter {

    private Logger log = Logger.getLogger(SoapBindingInputMessageAdapter.class.getName());

    private final Descriptions desc;

    public SoapBindingInputMessageAdapter(BPELProcess bpeldefinition) {
        this.desc = bpeldefinition.getImports();
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void adaptFromBindingInput(Execution execution, Message inputMessage, Variable variable, Direction direction,
            boolean isBindingStyleRpc) throws CoreException {
        if (isBindingStyleRpc) {
            // there is a binding operation element enclosing element parts.
            // do not take it into account to create variable payload (parts).
            assert variable instanceof MessageTypeVariable;
            List<Element> partsElements = (List<Element>) inputMessage.getBody().getPayload()
                    .getChildren();
            variable.assign(execution, partsElements.toArray(new Element[partsElements.size()]));
        } else {
            // must be a single part message
            if (variable instanceof MessageTypeVariable) {
                variable.assign(execution, new Element[] { inputMessage.getBody().getPayload() });
            } else {
                variable.assign(execution, inputMessage.getBody().getPayload());
            }
        }
    }

//    private boolean isSinglePartMessage(Message inputMessage) {
//        Service serviceDef = desc.findService(inputMessage.getService());
//        assert serviceDef != null;
//        Endpoint endpoint = serviceDef.getEndpoint(inputMessage.getEndpoint());
//        assert endpoint != null;
//        Binding binding = endpoint.getBinding();
//        assert binding != null;
//        BindingOperation bindingOperation = binding.getOperationByName(inputMessage
//                .getOperationName());
//        assert bindingOperation != null;
//        Operation operation = bindingOperation.findOperation();
//        assert operation != null;
//        return operation.getInput().getParts().length == 1;
//    }

    public final boolean isBindingStyleRpc(String endpointName, QName serviceName,
            QName interfaceName, String operationName) {
        Service serviceDef = desc.findService(serviceName);
        assert serviceDef != null;
        Endpoint endpoint = serviceDef.getEndpoint(endpointName);
        assert endpoint != null;
        Binding binding = endpoint.getBinding();
        assert binding != null;
        BindingOperation bindingOperation = binding.getOperationByName(operationName);
        assert bindingOperation != null;
        return bindingOperation.getStyle() == BindingStyle.RPC;
    }

}
