/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */

package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Binding.BindingStyle;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingOutputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;

public class SoapBindingOutputMessageAdapter implements BindingOutputMessageAdapter {

    private Logger log = Logger.getLogger(SoapBindingOutputMessageAdapter.class.getName());

    private final Descriptions desc;

    public SoapBindingOutputMessageAdapter(final BPELProcess bpeldefinition) {
        this.desc = bpeldefinition.getImports();
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }

    @Override
    public Message adaptToBindingOutput(Execution execution, Variable variable, String endpointName,
            QName serviceName, QName interfaceName, String operationName, Direction direction,
            boolean isBindingStyleRpc) throws CoreException {
        Message msg = null;
        msg = format(execution, variable, endpointName, serviceName, interfaceName, operationName,
                direction, isBindingStyleRpc);
        return msg;
    }

    private Message format(Execution execution, Variable variable, String endpointName, QName serviceName,
            QName interfaceName, String operationName, Direction direction,
            boolean isBindingStyleRpc) throws CoreException {
        if (variable.getValue(execution) == null) {
            throw new CoreException("GRRR");
        }

        // find the interface corresponding to the operation
        Operation op = null;
        final Interface itf = this.desc.findInterface(interfaceName);
        op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), operationName));

        Message internalMessage = new MessageImpl(op.getName());
        internalMessage.setEndpoint(endpointName);
        Element variableElement = (Element) variable.getValue(execution);
        internalMessage.setQName(new QName(variableElement.getNamespaceURI(), variableElement
                .getName()));
        internalMessage.setInterface(interfaceName);
        internalMessage.setService(serviceName);
        internalMessage.getBody().setPayload((Element) variable.getValue(execution));

        Message formattedMessage = new MessageImpl(op.getName());
        formattedMessage.getBody().setPayload((Element) variable.getValue(execution));

        if (op != null) {
            // TODO FIXME : this is a potential bug, we take the first one
            // found.
            Binding binding = null;
            for (final Binding bindingItem : (this.desc).getBindings()) {
                if ((bindingItem.getInterface() != null)
                        && bindingItem.getInterface().getQName().equals(itf.getQName())) {
                    binding = bindingItem;
                    break;
                }
            }

            // find the binding operation
            if (binding == null) {
                throw new CoreException("Impossible to find binding corresponding to interface: "
                        + itf.getQName());
            }
            BindingOperation bOp = binding.getOperationByName(op.getName());

            if (bOp != null) {
                if (!isBindingStyleRpc) {
                    this.log.finest("format as document");
                    formattedMessage = this.formatAsDocument(internalMessage, op, direction);
                } else {
                    this.log.finest("format as rpc");
                    formattedMessage = this.formatAsRpc(internalMessage, bOp, op, direction);
                }
            }

        }
        // add qname in external message if not exist
        formattedMessage.setQName(new QName(variableElement.getNamespaceURI(), variableElement
                .getName()));
        return formattedMessage;
    }

    private Message formatAsRpc(final Message internalMessage, final BindingOperation bOp,
            final Operation op, final Direction direction) throws BPELException {

        final Message formattedMessage = new MessageImpl(bOp.getName());

        if (internalMessage != null) {
            formattedMessage.getBody().setPayload(internalMessage.getBody().getPayload());
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setInterface(internalMessage.getInterface());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());

            // change message name by the binding operation name
            final org.jdom.Element elmt = (org.jdom.Element) internalMessage.getBody().getPayload()
                    .clone();

            String operationName = bOp.getName();
            if (direction == Direction.RESPONSE) {
                operationName = operationName + "Response";
            }
            elmt.setName(operationName);

            String targetNamespace = op.getParentInterface().getParentDescription()
                    .getTargetNamespace();
            if (!elmt.getNamespaceURI().equals(targetNamespace)) {
                elmt.setNamespace(Namespace.getNamespace(targetNamespace));
            }

            if (((op.getInput().getParts() != null) && (op.getInput().getParts().length > 0))
                    || op.getInput().getElement() != null) {
                final org.jdom.Document doc = new org.jdom.Document(elmt);
                formattedMessage.getBody().setPayload(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }

        return formattedMessage;
    }

    private Message formatAsDocument(final Message internalMessage, final Operation op,
            final Direction direction) throws BPELException {
        final Message formattedMessage = new MessageImpl(op.getName());

        if (internalMessage != null) {
            formattedMessage.getBody().setPayload(internalMessage.getBody().getPayload());
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setInterface(internalMessage.getInterface());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());

            // get the child element
            org.jdom.Element elmt = null;
            if ((internalMessage.getBody().getPayload().getChildren() != null)
                    && (internalMessage.getBody().getPayload().getChildren().size() == 1)
                    && (op.getInput().getMessageName().getLocalPart()
                            .equals(internalMessage.getQName().getLocalPart()) || ((op.getOutput() != null) && op
                            .getOutput().getMessageName().getLocalPart()
                            .equals(internalMessage.getQName().getLocalPart())))) {
                elmt = (org.jdom.Element) ((org.jdom.Element) internalMessage.getBody()
                        .getPayload().getChildren().get(0)).clone();
            } else {
                elmt = (org.jdom.Element) internalMessage.getBody().getPayload().clone();
            }

            // change root name of elmt if needed
            if ((direction == Direction.REQUEST) && (op.getInput() != null)) {
                if ((op.getInput().getParts() != null) && (op.getInput().getParts().length > 0)
                        && (op.getInput().getParts()[0].getType() != null)
                        && (op.getInput().getParts()[0].getQName() != null)) {
                    elmt.setName(op.getInput().getParts()[0].getQName().getLocalPart());
                    // elmt.setNamespace(Namespace.getNamespace(op.getInput().getParts().get(0).getPartQName().getNamespaceURI()));
                } else {
                    // TODO Check if we are in WSDL 2.0 (that has got no message
                    // (and no part)
                }
            }

            if (((op.getInput().getParts() != null) && (op.getInput().getParts().length > 0) && (op
                    .getInput().getParts()[0].getType() != null))) {
                elmt.setNamespace(null);
            }

            if (((op.getInput().getParts() != null) && (op.getInput().getParts().length > 0))
                    || op.getInput().getElement() != null) {
                final org.jdom.Document doc = new org.jdom.Document(elmt);
                formattedMessage.getBody().setPayload(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }
        return formattedMessage;
    }

    public Message formatFault(final Message internalMessage) {
        final Message res = new MessageImpl(internalMessage.getOperationName());
        // get only part inside the message
        res.getBody()
                .getPayload()
                .setContent(
                        Util.getChildElements((Element) internalMessage.getBody().getPayload())
                                .get(0));
        res.setEndpoint(internalMessage.getEndpoint());
        res.setQName(internalMessage.getQName());
        res.setService(internalMessage.getService());
        return res;
    }

    public Element getDetails(final Element fault) {
        Element details = null;

        // soap 1.1
        details = fault.getChild("detail",
                Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/"));
        if (details == null) {
            details = fault.getChild("detail");
        }

        // soap 1.2
        if (details == null) {
            details = fault.getChild("Detail",
                    Namespace.getNamespace("http://www.w3.org/2003/05/soap-envelope"));
        }
        if (details == null) {
            details = fault.getChild("Detail");
        }

        return details;
    }

    public static Element createSOAPFault(final Element content) {
        Element soapfault = null;

        // TODO: create soap1.2 fault

        // create soap1.1 fault
        soapfault = new Element("Fault", Namespace.getNamespace("soap",
                "http://schemas.xmlsoap.org/soap/envelope/"));
        final Document doc = new Document(soapfault);
        final Element faultcode = new Element("faultcode");
        faultcode.setText("soap:Server");
        soapfault.addContent(faultcode);

        final Element detail = new Element("detail");
        if (content != null) {
            detail.addContent((Element) content.clone());
        }
        soapfault.addContent(detail);

        return doc.getRootElement();
    }

    @Override
    public boolean isBindingStyleRpc(String endpointName, QName serviceName, QName interfaceName,
            String operationName) throws CoreException {
        // find the interface corresponding to the operation
        Operation op = null;
        final Interface itf = this.desc.findInterface(interfaceName);
        op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), operationName));
        assert op != null;
        // TODO FIXME : this is a potential bug, we take the first one found.
        Binding binding = null;
        for (final Binding bindingItem : (this.desc).getBindings()) {
            if ((bindingItem.getInterface() != null)
                    && bindingItem.getInterface().getQName().equals(itf.getQName())) {
                binding = bindingItem;
                break;
            }
        }
        if (binding == null) {
            throw new CoreException("Impossible to find binding corresponding to interface: "
                    + itf.getQName());
        }
        BindingOperation bOp = binding.getOperationByName(op.getName());
        return bOp.getStyle() == BindingStyle.RPC;
    }

}
