
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.impl.engine.variable.VariableImpl;

public abstract class AbstractVariableImpl extends VariableImpl<TVariable> {

    private static final long serialVersionUID = 502153910489683868L;

    @SuppressWarnings("rawtypes")
    protected AbstractVariableImpl(TVariable model, AbstractSchemaElementImpl parent) {
        super(model, parent);
        assert getModel().getName() != null;
    }

    protected abstract Object guessInitValue();

    protected Object setValueHook(Execution execution, Object obj) {
        return obj;
    }

    @Override
    public final void initialize(Execution execution) {
        if (model.getFrom() == null) {
            execution.putVariableValue(getName(), setValueHook(execution, guessInitValue()));
        } else {
            From from = new FromImpl(model.getFrom(), this);
            execution.putVariableValue(getName(), setValueHook(execution, from.resolve(execution)));
        }
    }

    @Override
    public Object getValue(Execution execution) {
        return execution.getVariableValue(getName());

    }
    
    
    @Override
    public final void assign(Execution execution, Object value) {
        execution.assignVariableValue(getName(), setValueHook(execution, value));
    }
        

}
