
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import java.util.List;

import org.jdom.Element;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

public class ElementVariableImpl extends AbstractVariableImpl implements ElementVariable {

    /**
	 * 
	 */
    private static final long serialVersionUID = -96063040861625808L;

    @SuppressWarnings("rawtypes")
    public ElementVariableImpl(TVariable model, SchemaElement parent) {
        super(model, (AbstractSchemaElementImpl) parent);
    }

    @Override
    public String getName() {
        return getModel().getName();
    }

    @Override
    public final Element getValue(Execution execution) {
        return (Element) super.getValue(execution);
    }

    @Override
    protected final Element guessInitValue() {
        BPELProcessImpl bpelProcess = (BPELProcessImpl) getTopParent();
        final List<com.ebmwebsourcing.easyschema10.api.element.Element> elmts = bpelProcess
                .getImports().findElementsInAllSchema(getModel().getElement());
        assert !elmts.isEmpty();
        final com.ebmwebsourcing.easyschema10.api.element.Element elmt = elmts.get(0);

        Schema parentSchema = SchemaHelper.findParentSchema(elmt);
        final Element element = XSD2XML.newInstance().generateElement(elmt, elmt, null,
                parentSchema.getElementFormDefault(), 1, false, true);

        return element;
    }

}
