package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.net.URI;
import java.util.List;

import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.ExpressionImpl;


abstract class AbstractBPELExpressionImpl extends ExpressionImpl<TExpression> implements BPELExpression {

	protected AbstractBPELExpressionImpl(String content, SchemaElement parent) {
		super(new TExpression(), (AbstractSchemaElementImpl) parent);
		setContent(content);
	}
	
	
	protected AbstractBPELExpressionImpl(TExpression model,
			SchemaElement parent) {
		super(model, (AbstractSchemaElementImpl) parent);
	}

	@Override
	public final String getContent() {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects.size() > 0;
		return String.valueOf(contentObjects.get(0));
	}

	
	private final void setContent(String content) {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects != null;
		contentObjects.clear();
		contentObjects.add(content);
	}
	
	
	@Override
	public final URI getExpressionLanguage() {
		String expressionLanguage = getModel().getExpressionLanguage();
		return expressionLanguage == null ? null : URI.create(expressionLanguage);
	}

	@Override
	public final void setExpressionLanguage(URI language) {
		getModel().setExpressionLanguage(String.valueOf(language));
	}
	

}
