package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.net.URI;
import java.util.List;

import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.ExpressionImpl;


public class BPELExpressionImpl extends ExpressionImpl<TExpression> implements BPELExpression {

	public BPELExpressionImpl(String content, SchemaElement parent) {
		super(new TExpression(), (AbstractSchemaElementImpl) parent);
		setContent(content);
	}
	
	
	public BPELExpressionImpl(TExpression model,
			SchemaElement parent) {
		super(model, (AbstractSchemaElementImpl) parent);
	}

	@Override
	public String getContent() {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects.size() > 0;
		return String.valueOf(contentObjects.get(0));
	}

	
	private void setContent(String content) {
		List<Object> contentObjects = getModel().getContent();
		assert contentObjects != null;
		contentObjects.clear();
		contentObjects.add(content);
	}
	
	
	
	@Override
	public URI getExpressionLanguage() {
		String expressionLanguage = getModel().getExpressionLanguage();
		return expressionLanguage == null ? null : URI.create(expressionLanguage);
	}

	@Override
	public void setExpressionLanguage(URI language) {
		getModel().setExpressionLanguage(String.valueOf(language));
	}
	

}
