/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */

package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.io.InputStream;
import java.net.URI;
import java.util.List;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jdom.Element;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DoXslTransformFunction implements Function {

    private final URI baseURI;

    public DoXslTransformFunction(URI baseURI) {
        this.baseURI = baseURI;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object call(Context context, List args) throws FunctionCallException {
        assert args.size() >= 2;
        String relativeUriString = (String) args.get(0);
        Element nodeSet = (Element) args.get(1);

        JDOMSource source = new JDOMSource(nodeSet);
        InputStream styleSheetStream = null;
        try {
            URI styleSheetUri = URIHelper.resolve(baseURI, relativeUriString);
            styleSheetStream = styleSheetUri.toURL().openStream();
            StreamSource styleSheet = new StreamSource(styleSheetStream);
            final TransformerFactory tFactory = TransformerFactory.newInstance();
            final Transformer transformer = tFactory.newTransformer(styleSheet);

            if (args.size() > 2) {
                // key-value pairs.
                assert args.size() % 2 == 0;
                for (int i = 2; i < args.size(); i = i + 2) {
                	Object value = args.get(i+1);
                	if(value instanceof Element) {
                		value = ((Element)value).getText();
                	}
                	
                    transformer.setParameter(String.valueOf(args.get(i)), value);
                }
            }

            JDOMResult result = new JDOMResult();
            transformer.transform(source, result);
            return result.getDocument().getRootElement();
            
        } catch (Exception e) {
            throw new UncheckedException(e);
        } finally {
            IOHelper.close(styleSheetStream);
        }
    }

}
