/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TThrow;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ThrowImpl extends ActivityImpl<TThrow> implements Throw {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	public ThrowImpl(final TThrow model, final BPELElement parent) {
		super(Constants._Throw_QNAME, model, parent);
		
	}


	public QName getFaultName() {
		return this.model.getFaultName();
	}


	@Override
	public String getName() {
		return this.model.getName();
	}

	public String getFaultVariable() {
		return this.model.getFaultVariable();
	}

}
