/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Property;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationSetValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class CorrelationSetValidatorImpl implements CorrelationSetValidator {

    private CorrelationSet correlationSet = null;

    public CorrelationSetValidatorImpl(final CorrelationSet correlationSet) {
        this.correlationSet = correlationSet;
    }

    public void validate() {
        // validation
        // validation if null or empty
        if ((this.correlationSet.getName() == null)
                || (this.correlationSet.getName().trim().length() == 0)) {
            BPELStaticAnalysisImpl
                    .getInstance()
                    .addError(
                            new BPELErrorImpl(
                                    this.correlationSet,
                                    new BPELException(
                                            "In CorrelationSet => The name cannot be null or empty")));
        }
        if ((this.correlationSet.getProperties() == null)
                || (this.correlationSet.getProperties().size() == 0)) {
            BPELStaticAnalysisImpl
                    .getInstance()
                    .addError(
                            new BPELErrorImpl(
                                    this.correlationSet,
                                    new BPELException(
                                            "In CorrelationSet => The properties cannot be null or empty")));
        }

        // validation on content
        final BPELProcess process = ScopeUtil.getProcess((this.correlationSet));

        if (this.correlationSet.getProperties() != null) {
            for (final QName propertyName : this.correlationSet.getProperties()) {
                final Property prop = process.getImports().getProperty(
                        propertyName);
                if (prop == null) {
                    BPELStaticAnalysisImpl.getInstance().addError(
                            new BPELErrorImpl(this.correlationSet,
                                    new BPELException(
                                            "In CorrelationSet => Impossible to find property corresponding to this name "
                                                    + propertyName)));
                }
            }
        }
    }

}
