/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter.Direction;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class BPELCorrelationMatcher implements CorrelationMatcher {

    private Logger log = Logger.getLogger(BPELCorrelationMatcher.class
            .getName());

    private final Descriptions desc;

    private final BPELProcess bpeldefinition;

    private final List<Correlation> correlations;

    private String variableToCorrelate = null;

    public BPELCorrelationMatcher(final BPELProcess bpeldefinition,
            final List<Correlation> correlations, final String inputVariable) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.correlations = correlations;
        this.variableToCorrelate = inputVariable;
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }

    public boolean match(Execution execution, final String variableName,
            final Message message, BindingInputMessageAdapter messageAdapter, QName interfaceName) throws CoreException {
        boolean res = false;
        Scope scope = execution.getCurrentScope();
        
        try {
            // verif variable
            if (this.variableToCorrelate.equals(variableName)) {

                // get variable from
                final Variable varFrom = scope.findVariable(this.variableToCorrelate);
                if (varFrom == null) {
                    throw new CoreException(
                            "Impossible to find variable corresponding to this name "
                                    + this.variableToCorrelate);
                }

                List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
                if (this.correlations != null) {
                    this.log.finest("get specific correlations");
                    for (final Correlation corr : this.correlations) {
                        correlationGroups.addAll(scope
                                .findCorrelationGroups(corr.getSet()));
                    }
                } else {
                    this.log.finest("get global correlations on the scope: "
                            + scope.getName());
                    correlationGroups = scope.getProcess()
                            .getCorrelationGroups();
                }

                this.log.finest("correlationGroups size: "
                        + correlationGroups.size());
                if (correlationGroups.size() > 0) {
                    for (final CorrelationGroup correlationGroup : correlationGroups) {
                        // get correlation
                        for (final Entry<String, com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation> correlation : correlationGroup
                                .getCorrelations().entrySet()) {
                            // find CorrelationSet
                            final CorrelationSet correlationSet = this.bpeldefinition
                                    .getCorrelationSet(correlation.getKey());
                            if (correlationSet == null) {
                                throw new CoreException(
                                        "Impossible to find the correlation set corresponding to this name "
                                                + correlation.getKey());
                            }
                            this.log.finest("control correlation: "
                                    + correlationSet.getName());

                            // find corresponding properties
                            final List<QName> propertiesName = correlationSet
                                    .getProperties();
                            for (final QName propertyName : propertiesName) {

                                final Property prop = this.desc
                                        .getProperty(propertyName);
                                if (prop == null) {
                                    throw new BPELException(
                                            "Impossible to find property corresponding to this name "
                                                    + propertyName);
                                }

                                final com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation corr = correlation
                                        .getValue();
                                final To to = (To) corr.getOriginator();
                                // get variable to
                                final Variable varTo = scope.findVariable(to.getVariable());
                                if (varTo == null) {
                                    throw new CoreException(
                                            "Impossible to find variable corresponding to this name "
                                                    + to.getVariable());
                                }

                                final PropertyAlias propAliasTo = this.findCorrespondingPropertiesAlias(
                                      prop.getQName(), varTo);
                                
                                TFrom tfrom = new TFrom();
                                tfrom.setProperty(propAliasTo.getQName());
                                tfrom.setVariable(variableName);
                                
                                
                                
                                final From from = new FromImpl(tfrom, ((AbstractSchemaElementImpl) to).getParent());
                                
                                boolean isBindingStyleRpc = messageAdapter.isBindingStyleRpc(
                                        message.getEndpoint(), message.getService(), interfaceName, message.getOperationName());
                                messageAdapter.adaptFromBindingInput(execution, 
                                        message, varFrom, Direction.REQUEST, isBindingStyleRpc);
                           
                                Object resolvedFrom = from.resolve(execution);
                                Object resolvedTo = to.resolve(execution);
                                XMLOutputter xmlOutputter = new XMLOutputter();
                                boolean condition = areEquals(resolvedFrom, resolvedTo); 
                                if (condition) {
                                    res = true;
                                } else {
                                    res = false;
                                    varFrom.assign(null, null);
                                }
                            }
                        }
                    }
                } else {
                    res = true;
                }
            }
        } catch (final BPELException e) {
            throw new CoreException(e);
        }
        return res;
    }


    
    private static final boolean areEquals(Object o1, Object o2) {
        
        if (o1 instanceof String) {
            return o1.equals(o2);
        } else if (o1 instanceof Element) {
            Element e1 = (Element) o1;
            Element e2 = (Element) o2;

            // FIXME : if we used DOM, we could have a more robust code with XMLComparator.
            // unfortunately, only to convert a single JDOM element to DOM element is
            // to serialize as string.
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getCompactFormat());
            try {
                xmlOutputter.output(e1, baos1);
                xmlOutputter.output(e2, baos2);
            } catch (IOException e) {
                throw new UncheckedException(e);
            }
            
            
            ByteArrayInputStream bais1 = new ByteArrayInputStream(baos1.toByteArray());
            ByteArrayInputStream bais2 = new ByteArrayInputStream(baos1.toByteArray());
            return XMLComparator.isEquivalent(bais1, bais2);
        } else {
            throw new UnsupportedOperationException();
        }
    }

	@SuppressWarnings("unchecked")
	private PropertyAlias findCorrespondingPropertiesAlias(
            final QName propertyName, final Variable var)
            throws BPELException {
        PropertyAlias res = null;
        // find corresponding propertiesAlias
        List<PropertyAlias> propertiesAliases;

        propertiesAliases = this.desc
                .getPropertyAliases4ThisProperty(propertyName);

        TVariable varDef = ((AbstractSchemaElementImpl<TVariable>) var).getModel();
        if (propertiesAliases != null) {

            for (final PropertyAlias propertyAlias : propertiesAliases) {

                // math correlation with variable
                boolean correlationMatching = false;

                if ((propertyAlias.getElement() != null)
                        && (propertyAlias.getElement().equals(varDef.getElement()))) {
                    correlationMatching = true;
                } else if ((propertyAlias.getMessageType() != null)
                        && (propertyAlias.getMessageType().equals(varDef
                                .getMessageType()))) {
                    correlationMatching = true;
                } else if ((propertyAlias.getType() != null)
                        && (propertyAlias.getType().equals(varDef.getType()))) {
                    correlationMatching = true;
                }

                if (correlationMatching) {
                    res = propertyAlias;
                    break;
                }
            }
        }

        return res;
    }

}
