/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.impl.engine.variable.VariableImpl;

public abstract class AbstractVariableImpl extends VariableImpl<TVariable> {

    private static final long serialVersionUID = 502153910489683868L;

    @SuppressWarnings("rawtypes")
    protected AbstractVariableImpl(TVariable model, AbstractSchemaElementImpl parent) {
        super(model, parent);
        assert getModel().getName() != null;
    }

    protected abstract Object guessInitValue();

    protected Object setValueHook(Execution execution, Object obj) {
        return obj;
    }

    @Override
    public final void initialize(Execution execution) {
        if (model.getFrom() == null) {
            execution.putVariableValue(getName(), setValueHook(execution, guessInitValue()));
        } else {
            From from = new FromImpl(model.getFrom(), this);
            execution.putVariableValue(getName(), setValueHook(execution, from.resolve(execution)));
        }
    }

    @Override
    public Object getValue(Execution execution) {
        return execution.getVariableValue(getName());

    }
    
    
    @Override
    public final void assign(Execution execution, Object value) {
        execution.assignVariableValue(getName(), setValueHook(execution, value));
    }
        

}
