/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;

public class BPELCorrelationMatcher
implements CorrelationMatcher {
    private Logger log = Logger.getLogger(BPELCorrelationMatcher.class.getName());
    private final Descriptions desc;
    private final BPELProcess bpeldefinition;
    private final List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> correlations;
    private String variableToCorrelate = null;

    public BPELCorrelationMatcher(BPELProcess bpeldefinition, List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> correlations, String inputVariable) {
        this.desc = bpeldefinition.getImports();
        this.bpeldefinition = bpeldefinition;
        this.correlations = correlations;
        this.variableToCorrelate = inputVariable;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public boolean match(Execution execution, String variableName, Message message, BindingInputMessageAdapter messageAdapter, QName interfaceName) throws CoreException {
        boolean res = false;
        Scope scope = execution.getCurrentScope();
        try {
            if (this.variableToCorrelate.equals(variableName)) {
                Variable varFrom = scope.findVariable(this.variableToCorrelate);
                if (varFrom == null) {
                    throw new CoreException("Impossible to find variable corresponding to this name " + this.variableToCorrelate);
                }
                List correlationGroups = new ArrayList();
                if (this.correlations != null) {
                    this.log.finest("get specific correlations");
                    for (com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation corr : this.correlations) {
                        correlationGroups.addAll(scope.findCorrelationGroups(corr.getSet()));
                    }
                } else {
                    this.log.finest("get global correlations on the scope: " + scope.getName());
                    correlationGroups = scope.getProcess().getCorrelationGroups();
                }
                this.log.finest("correlationGroups size: " + correlationGroups.size());
                if (correlationGroups.size() > 0) {
                    for (CorrelationGroup correlationGroup : correlationGroups) {
                        for (Map.Entry correlation : correlationGroup.getCorrelations().entrySet()) {
                            CorrelationSet correlationSet = this.bpeldefinition.getCorrelationSet((String)correlation.getKey());
                            if (correlationSet == null) {
                                throw new CoreException("Impossible to find the correlation set corresponding to this name " + (String)correlation.getKey());
                            }
                            this.log.finest("control correlation: " + correlationSet.getName());
                            List propertiesName = correlationSet.getProperties();
                            for (QName propertyName : propertiesName) {
                                Property prop = this.desc.getProperty(propertyName);
                                if (prop == null) {
                                    throw new BPELException("Impossible to find property corresponding to this name " + propertyName);
                                }
                                Correlation corr = (Correlation)correlation.getValue();
                                To to = (To)corr.getOriginator();
                                Variable varTo = scope.findVariable(to.getVariable());
                                if (varTo == null) {
                                    throw new CoreException("Impossible to find variable corresponding to this name " + to.getVariable());
                                }
                                PropertyAlias propAliasTo = this.findCorrespondingPropertiesAlias(prop.getQName(), varTo);
                                TFrom tfrom = new TFrom();
                                tfrom.setProperty(propAliasTo.getQName());
                                tfrom.setVariable(variableName);
                                FromImpl from = new FromImpl(tfrom, ((AbstractSchemaElementImpl)to).getParent());
                                boolean isBindingStyleRpc = messageAdapter.isBindingStyleRpc(message.getEndpoint(), message.getService(), interfaceName, message.getOperationName());
                                messageAdapter.adaptFromBindingInput(execution, message, varFrom, BindingMessageAdapter.Direction.REQUEST, isBindingStyleRpc);
                                Object resolvedFrom = from.resolve(execution);
                                Object resolvedTo = to.resolve(execution);
                                XMLOutputter xmlOutputter = new XMLOutputter();
                                boolean condition = BPELCorrelationMatcher.areEquals(resolvedFrom, resolvedTo);
                                if (condition) {
                                    res = true;
                                    continue;
                                }
                                res = false;
                                varFrom.assign(null, null);
                            }
                        }
                    }
                } else {
                    res = true;
                }
            }
        }
        catch (BPELException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    private static final boolean areEquals(Object o1, Object o2) {
        if (o1 instanceof String) {
            return o1.equals(o2);
        }
        if (o1 instanceof Element) {
            Element e1 = (Element)o1;
            Element e2 = (Element)o2;
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getCompactFormat());
            try {
                xmlOutputter.output(e1, (OutputStream)baos1);
                xmlOutputter.output(e2, (OutputStream)baos2);
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
            ByteArrayInputStream bais1 = new ByteArrayInputStream(baos1.toByteArray());
            ByteArrayInputStream bais2 = new ByteArrayInputStream(baos1.toByteArray());
            return XMLComparator.isEquivalent((InputStream)bais1, (InputStream)bais2);
        }
        throw new UnsupportedOperationException();
    }

    private PropertyAlias findCorrespondingPropertiesAlias(QName propertyName, Variable var) throws BPELException {
        PropertyAlias res = null;
        List propertiesAliases = this.desc.getPropertyAliases4ThisProperty(propertyName);
        TVariable varDef = (TVariable)((AbstractSchemaElementImpl)var).getModel();
        if (propertiesAliases != null) {
            for (PropertyAlias propertyAlias : propertiesAliases) {
                boolean correlationMatching = false;
                if (propertyAlias.getElement() != null && propertyAlias.getElement().equals(varDef.getElement())) {
                    correlationMatching = true;
                } else if (propertyAlias.getMessageType() != null && propertyAlias.getMessageType().equals(varDef.getMessageType())) {
                    correlationMatching = true;
                } else if (propertyAlias.getType() != null && propertyAlias.getType().equals(varDef.getType())) {
                    correlationMatching = true;
                }
                if (!correlationMatching) continue;
                res = propertyAlias;
                break;
            }
        }
        return res;
    }
}

