/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CopyValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;


public class CopyValidatorImpl implements CopyValidator {

	private static Logger log = Logger.getLogger(CopyValidatorImpl.class.getName());

	private Copy copy = null;

	public CopyValidatorImpl(final Copy copy) {
		this.copy = copy;
	}

	public void validate() {

		// validation
		log.finest("validate copy");

		// unsupported element
		if((((TCopy)((BPELElementImpl)this.copy).getModel()).getKeepSrcElementName() != null) && ((TCopy)((BPELElementImpl)this.copy).getModel()).getKeepSrcElementName().equals(TBoolean.YES)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.copy, "In copy => [BPEL engine restriction] Sorry, but the keepSrcElementName attribute at yes is ignored for the moment"));
		}
		if((((TCopy)((BPELElementImpl)this.copy).getModel()).getIgnoreMissingFromData() != null) && ((TCopy)((BPELElementImpl)this.copy).getModel()).getIgnoreMissingFromData().equals(TBoolean.YES)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.copy, "In copy => [BPEL engine restriction] Sorry, but the ignoreMissingFromData attribute at yes is ignored for the moment"));
		}

		// validation if exist
		if(((TCopy)((BPELElementImpl)this.copy).getModel()).getFrom() == null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.copy, new BPELException("In copy => the from element cannot be null")));
		}
		if(((TCopy)((BPELElementImpl)this.copy).getModel()).getTo() == null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.copy, new BPELException("In copy => the to element cannot be null")));
		}
	}

}
