/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jdom.Element;
import org.jdom.Namespace;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class GetVariablePropertyFunction implements Function {

	private static Logger log = Logger.getLogger(GetVariablePropertyFunction.class.getName());

	private Execution execution;


	public GetVariablePropertyFunction(Execution execution) {
		this.execution = execution;
	}

	@Override
	public Object call(Context context, List args) throws FunctionCallException {
		assert args.size() == 2;
		Element res = null;
		String variable = (String) args.get(0);
		String property = (String) args.get(1);
		try {
			org.jdom.Document doc = new org.jdom.Document(res);
			// find variable
			if("process".equals(variable)) {
				com.ebmwebsourcing.easyviper.core.api.engine.Process process = this.execution.getCurrentScope().getProcess();
				if("name".equals(property)) {
					res = new Element("value");
					res.setAttribute("type", "xsd:string");
					res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
							com.ebmwebsourcing.easyschema10.api.Constants.XMLSCHEMA_NS_URI));

					res.setText(QName.valueOf(process.getName()).getLocalPart());
				} else {
					throw new XPathExpressionException(
							"This property is unknown of the variable 'process': " + property);
				}
			} else if("env".equals(variable)) {
				com.ebmwebsourcing.easyviper.core.api.engine.Process process = this.execution.getCurrentScope().getProcess();
				if("host".equals(property)) {
					res = new Element("value");
					res.setAttribute("type", "xsd:string");
					res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
							com.ebmwebsourcing.easyschema10.api.Constants.XMLSCHEMA_NS_URI));

					res.setText(process.getEngine().getCore().getExternalEnvironment().getHost());
				} else if("port".equals(property)) {
					res = new Element("value");
					res.setAttribute("type", "xsd:string");
					res.addNamespaceDeclaration(Namespace.getNamespace("xsd",
							com.ebmwebsourcing.easyschema10.api.Constants.XMLSCHEMA_NS_URI));

					res.setText(process.getEngine().getCore().getExternalEnvironment().getPort());
				} else {
					throw new XPathExpressionException(
							"This property is unknown of the variable 'process': " + property);
				}
			} else {
				throw new XPathExpressionException(
						"This variable is unknown of this engine: " + variable);
			}
		} catch (CoreException e) {
			throw new XPathExpressionException(e);
		}
		return res;
	}

}
