/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.TypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.SelectionFailureException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.AbstractVariableImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.GetVariablePropertyFunction;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import java.util.List;
import java.util.Map;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.Namespace;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private final BPELProcess bpelProcess;
    private final Scope scope;

    public ExpressionEvaluatorImpl(BPELProcess bpelProcess, Scope scope) {
        this.bpelProcess = bpelProcess;
        this.scope = scope;
    }

    public boolean evaluateAsBoolean(Execution execution, Expression expression) {
        try {
            XPath xpath = this.createXPath(execution, expression);
            return xpath.booleanValueOf(null);
        }
        catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    public int evaluateAsInteger(Execution execution, Expression expression) {
        try {
            XPath xpath = this.createXPath(execution, expression);
            return xpath.numberValueOf(null).intValue();
        }
        catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    public String evaluateAsString(Execution execution, Expression expression) {
        try {
            XPath xpath = this.createXPath(execution, expression);
            return xpath.stringValueOf(null);
        }
        catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    public Object evaluateAsNode(Execution execution, Expression expression) {
        return this.evaluateAsNode(execution, expression, null);
    }

    public Object evaluateAsNode(Execution execution, Expression expression, Object contextNode) {
        try {
            System.err.println("XPATH = " + expression.getContent());
            XPath xpath = this.createXPath(execution, expression);
            Object result = xpath.selectSingleNode(contextNode);
            System.err.println("XPATH RESULT = " + result);
            return result;
        }
        catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
    }

    private final XPath createXPath(Execution execution, Expression expression) {
        JDOMXPath xpath;
        XPathFunctionContext functionContext = new XPathFunctionContext();
        functionContext.registerFunction("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "doXslTransform", (Function)new DoXslTransformFunction(this.bpelProcess.getDocumentBaseURI()));
        functionContext.registerFunction("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "getVariableProperty", (Function)new GetVariablePropertyFunction(execution));
        SimpleVariableContext variableContext = new SimpleVariableContext();
        try {
            xpath = new JDOMXPath(expression.getContent());
        }
        catch (JaxenException e) {
            throw new SelectionFailureException(expression);
        }
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        BPELProcessImpl bpelProcess = this.findBpelProcess(expression);
        if (bpelProcess != null) {
            for (Description desc : bpelProcess.getImports().getDescriptions()) {
                for (Map.Entry namespaceBinding : desc.getNamespaces().entrySet()) {
                    namespaceContext.addNamespace((String)namespaceBinding.getKey(), (String)namespaceBinding.getValue());
                }
            }
            Map namespaceBindings = bpelProcess.getNamespaceContext().getNamespaces();
            for (Map.Entry namespaceBinding : namespaceBindings.entrySet()) {
                namespaceContext.addNamespace((String)namespaceBinding.getKey(), (String)namespaceBinding.getValue());
            }
        }
        if (this.scope != null) {
            Map variables = this.scope.getInScopeVariables();
            for (Map.Entry entry : variables.entrySet()) {
                Object variableValue;
                String variableName = (String)entry.getKey();
                assert (variableName != null);
                Variable bpelVariable = (Variable)entry.getValue();
                System.err.println("-*-*- DECL var " + bpelVariable.getName());
                if (bpelVariable instanceof MessageTypeVariable) {
                    MessageTypeVariable messageTypeVariable = (MessageTypeVariable)bpelVariable;
                    Element rootMessageElement = messageTypeVariable.getValue(execution);
                    Part[] parts = ExpressionEvaluatorImpl.retrievePartsFromMessageElement((AbstractVariableImpl)bpelVariable);
                    List children = rootMessageElement.getChildren();
                    assert (children.size() == parts.length);
                    int i = 0;
                    for (Element partElement : children) {
                        if (!partElement.getNamespacePrefix().isEmpty()) {
                            namespaceContext.addNamespace(partElement.getNamespacePrefix(), partElement.getNamespaceURI());
                        }
                        for (Namespace additionalNamespace : partElement.getAdditionalNamespaces()) {
                            namespaceContext.addNamespace(additionalNamespace.getPrefix(), additionalNamespace.getURI());
                        }
                        String partName = parts[i].getQName().getLocalPart();
                        String partVariableName = String.valueOf(variableName) + "." + partName;
                        this.declareVariableInVariableContext(partVariableName, partElement, variableContext);
                        ++i;
                    }
                    continue;
                }
                if (bpelVariable instanceof ElementVariable) {
                    variableValue = ((ElementVariable)bpelVariable).getValue(execution);
                    this.declareVariableInVariableContext(variableName, variableValue, variableContext);
                    continue;
                }
                if (bpelVariable instanceof TypeVariable) {
                    variableValue = ((TypeVariable)bpelVariable).getValue(execution);
                    this.declareVariableInVariableContext(variableName, variableValue, variableContext);
                    continue;
                }
                assert (false);
            }
        }
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        xpath.setVariableContext((VariableContext)variableContext);
        xpath.setFunctionContext((FunctionContext)functionContext);
        return xpath;
    }

    private void declareVariableInVariableContext(String variableName, Object variableValue, SimpleVariableContext variableContext) {
        variableContext.setVariableValue(variableName, variableValue);
    }

    private final BPELProcessImpl findBpelProcess(Expression expression) {
        assert (expression != null);
        AbstractSchemaElementImpl elementImpl = (AbstractSchemaElementImpl)expression;
        if (!(elementImpl.getTopParent() instanceof BPELProcessImpl)) {
            return null;
        }
        BPELProcessImpl bpelProcess = (BPELProcessImpl)elementImpl.getTopParent();
        return bpelProcess;
    }

    private static final Part[] retrievePartsFromMessageElement(AbstractVariableImpl bpelVariable) {
        TVariable varDef = (TVariable)bpelVariable.getModel();
        BPELProcessImpl bpelProcess = (BPELProcessImpl)bpelVariable.getTopParent();
        Message message = bpelProcess.getImports().findMessage(varDef.getMessageType());
        return message.getParts();
    }
}

