/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELStaticAnalysis;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PartnerLinkValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELWarningImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;
import java.net.URI;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.petalslink.abslayer.WSDLVersionConstants;

public class ImportValidatorImpl
implements PartnerLinkValidator {
    private Import _import = null;

    public ImportValidatorImpl(Import _import) {
        this._import = _import;
    }

    public void validate() {
        if (this._import.getImportType() == null || this._import.getImportType().toString().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((SchemaElement)this._import, new BPELException("In one import => the importType cannot be null or empty")));
        }
        if (this._import.getLocation() == null || this._import.getLocation().toString().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addWarning((Warning)new BPELWarningImpl(this._import, "In one import => the location is null or empty"));
        }
        if (this._import.getNamespace() == null || this._import.getNamespace().toString().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addWarning((Warning)new BPELWarningImpl(this._import, "In one import => the namespace is null or empty"));
        }
        BPELProcess process = ScopeUtil.getProcess((SchemaElement)this._import);
        URI baseUri = process.getDocumentBaseURI();
        if (!(this._import.getImportType() == null || this._import.getImportType().toString().equals(WSDLVersionConstants.WSDL11.value().toString()) || this._import.getImportType().toString().equals(WSDLVersionConstants.WSDL20.value().toString()) || this._import.getImportType().toString().equals("http://www.w3.org/2001/XMLSchema"))) {
            BPELStaticAnalysisImpl.getInstance().addError((Error)new BPELErrorImpl((SchemaElement)this._import, new BPELException(BPELStaticAnalysis.SA0013)));
        }
    }
}

