/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.tools.Util;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingOutputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;

public class SoapBindingOutputMessageAdapter
implements BindingOutputMessageAdapter {
    private Logger log = Logger.getLogger(SoapBindingOutputMessageAdapter.class.getName());
    private final Descriptions desc;

    public SoapBindingOutputMessageAdapter(BPELProcess bpeldefinition) {
        this.desc = bpeldefinition.getImports();
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public Message adaptToBindingOutput(Execution execution, Variable variable, String endpointName, QName serviceName, QName interfaceName, String operationName, BindingMessageAdapter.Direction direction, boolean isBindingStyleRpc) throws CoreException {
        Message msg = null;
        msg = this.format(execution, variable, endpointName, serviceName, interfaceName, operationName, direction, isBindingStyleRpc);
        return msg;
    }

    private Message format(Execution execution, Variable variable, String endpointName, QName serviceName, QName interfaceName, String operationName, BindingMessageAdapter.Direction direction, boolean isBindingStyleRpc) throws CoreException {
        if (variable.getValue(execution) == null) {
            throw new CoreException("GRRR");
        }
        Operation op = null;
        Interface itf = this.desc.findInterface(interfaceName);
        op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), operationName));
        MessageImpl internalMessage = new MessageImpl(op.getName());
        internalMessage.setEndpoint(endpointName);
        Element variableElement = (Element)variable.getValue(execution);
        internalMessage.setQName(new QName(variableElement.getNamespaceURI(), variableElement.getName()));
        internalMessage.setInterface(interfaceName);
        internalMessage.setService(serviceName);
        internalMessage.getBody().setPayload((Element)variable.getValue(execution));
        MessageImpl formattedMessage = new MessageImpl(op.getName());
        formattedMessage.getBody().setPayload((Element)variable.getValue(execution));
        if (op != null) {
            Binding binding = null;
            for (Binding bindingItem : this.desc.getBindings()) {
                if (bindingItem.getInterface() == null || !bindingItem.getInterface().getQName().equals(itf.getQName())) continue;
                binding = bindingItem;
                break;
            }
            if (binding == null) {
                throw new CoreException("Impossible to find binding corresponding to interface: " + itf.getQName());
            }
            BindingOperation bOp = binding.getOperationByName(op.getName());
            if (bOp != null) {
                if (!isBindingStyleRpc) {
                    this.log.finest("format as document");
                    formattedMessage = this.formatAsDocument((Message)internalMessage, op, direction);
                } else {
                    this.log.finest("format as rpc");
                    formattedMessage = this.formatAsRpc((Message)internalMessage, bOp, op, direction);
                }
            }
        }
        formattedMessage.setQName(new QName(variableElement.getNamespaceURI(), variableElement.getName()));
        return formattedMessage;
    }

    private Message formatAsRpc(Message internalMessage, BindingOperation bOp, Operation op, BindingMessageAdapter.Direction direction) throws BPELException {
        MessageImpl formattedMessage = new MessageImpl(bOp.getName());
        if (internalMessage != null) {
            formattedMessage.getBody().setPayload(internalMessage.getBody().getPayload());
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setInterface(internalMessage.getInterface());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());
            Element elmt = (Element)internalMessage.getBody().getPayload().clone();
            String operationName = bOp.getName();
            if (direction == BindingMessageAdapter.Direction.RESPONSE) {
                operationName = String.valueOf(operationName) + "Response";
            }
            elmt.setName(operationName);
            String targetNamespace = op.getParentInterface().getParentDescription().getTargetNamespace();
            if (!elmt.getNamespaceURI().equals(targetNamespace)) {
                elmt.setNamespace(Namespace.getNamespace((String)targetNamespace));
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 || op.getInput().getElement() != null) {
                Document doc = new Document(elmt);
                formattedMessage.getBody().setPayload(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }
        return formattedMessage;
    }

    private Message formatAsDocument(Message internalMessage, Operation op, BindingMessageAdapter.Direction direction) throws BPELException {
        MessageImpl formattedMessage = new MessageImpl(op.getName());
        if (internalMessage != null) {
            formattedMessage.getBody().setPayload(internalMessage.getBody().getPayload());
            formattedMessage.setEndpoint(internalMessage.getEndpoint());
            formattedMessage.setInterface(internalMessage.getInterface());
            formattedMessage.setQName(internalMessage.getQName());
            formattedMessage.setService(internalMessage.getService());
            Element elmt = null;
            elmt = internalMessage.getBody().getPayload().getChildren() != null && internalMessage.getBody().getPayload().getChildren().size() == 1 && (op.getInput().getMessageName().getLocalPart().equals(internalMessage.getQName().getLocalPart()) || op.getOutput() != null && op.getOutput().getMessageName().getLocalPart().equals(internalMessage.getQName().getLocalPart())) ? (Element)((Element)internalMessage.getBody().getPayload().getChildren().get(0)).clone() : (Element)internalMessage.getBody().getPayload().clone();
            if (direction == BindingMessageAdapter.Direction.REQUEST && op.getInput() != null && op.getInput().getParts() != null && op.getInput().getParts().length > 0 && op.getInput().getParts()[0].getType() != null && op.getInput().getParts()[0].getQName() != null) {
                elmt.setName(op.getInput().getParts()[0].getQName().getLocalPart());
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 && op.getInput().getParts()[0].getType() != null) {
                elmt.setNamespace(null);
            }
            if (op.getInput().getParts() != null && op.getInput().getParts().length > 0 || op.getInput().getElement() != null) {
                Document doc = new Document(elmt);
                formattedMessage.getBody().setPayload(doc.getRootElement());
            }
        } else {
            throw new BPELException("Internal message cannot be null.");
        }
        return formattedMessage;
    }

    public Message formatFault(Message internalMessage) {
        MessageImpl res = new MessageImpl(internalMessage.getOperationName());
        res.getBody().getPayload().setContent((Content)Util.getChildElements(internalMessage.getBody().getPayload()).get(0));
        res.setEndpoint(internalMessage.getEndpoint());
        res.setQName(internalMessage.getQName());
        res.setService(internalMessage.getService());
        return res;
    }

    public Element getDetails(Element fault) {
        Element details = null;
        details = fault.getChild("detail", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/"));
        if (details == null) {
            details = fault.getChild("detail");
        }
        if (details == null) {
            details = fault.getChild("Detail", Namespace.getNamespace((String)"http://www.w3.org/2003/05/soap-envelope"));
        }
        if (details == null) {
            details = fault.getChild("Detail");
        }
        return details;
    }

    public static Element createSOAPFault(Element content) {
        Element soapfault = null;
        soapfault = new Element("Fault", Namespace.getNamespace((String)"soap", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        Document doc = new Document(soapfault);
        Element faultcode = new Element("faultcode");
        faultcode.setText("soap:Server");
        soapfault.addContent((Content)faultcode);
        Element detail = new Element("detail");
        if (content != null) {
            detail.addContent((Content)((Element)content.clone()));
        }
        soapfault.addContent((Content)detail);
        return doc.getRootElement();
    }

    public boolean isBindingStyleRpc(String endpointName, QName serviceName, QName interfaceName, String operationName) throws CoreException {
        Operation op = null;
        Interface itf = this.desc.findInterface(interfaceName);
        op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), operationName));
        assert (op != null);
        Binding binding = null;
        for (Binding bindingItem : this.desc.getBindings()) {
            if (bindingItem.getInterface() == null || !bindingItem.getInterface().getQName().equals(itf.getQName())) continue;
            binding = bindingItem;
            break;
        }
        if (binding == null) {
            throw new CoreException("Impossible to find binding corresponding to interface: " + itf.getQName());
        }
        BindingOperation bOp = binding.getOperationByName(op.getName());
        return bOp.getStyle() == Binding.BindingStyle.RPC;
    }
}

