/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnAlarmImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;


/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class PickImpl extends ActivityImpl<TPick> implements Pick {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final List<OnMessage> messages = new ArrayList<OnMessage>();
	private final List<OnAlarm> alarms = new ArrayList<OnAlarm>();

	public PickImpl(final TPick model, final BPELElement parent) {
		super(Constants._Pick_QNAME, model, parent);
		
		for(final TOnMessage msg: this.model.getOnMessage()) {
			this.messages.add(new OnMessageImpl(msg, this));
		}
		for(final TOnAlarmPick alarm : this.model.getOnAlarm()) {
			this.alarms.add(new OnAlarmImpl(alarm, this));
		}
	}
	

	public List<OnMessage> getOnMessages() {
		return this.messages;
	}
	
	public List<OnAlarm> getOnAlarms() {
		return this.alarms;
	}


	public boolean getCreateInstance() {
		boolean res = false;
		if((this.model.getCreateInstance() != null) && this.model.getCreateInstance().equals(TBoolean.YES)) {
			res = true;
		} else {
			res = false;
		}
		return res;
	}
	
	public void setCreateInstance(boolean createInstance) {
		if(createInstance) {
			this.model.setCreateInstance(TBoolean.YES);
		} else {
			this.model.setCreateInstance(TBoolean.NO);
		}
	}
	
	public void addOnMessage(OnMessage m){
		this.messages.add(m);
		this.model.getOnMessage().add((TOnMessage) ((AbstractSchemaElementImpl<?>)m).getModel());
	}
	
	public void addOnAlarm(OnAlarm a){
		this.alarms.add(a);
		this.model.getOnAlarm().add((TOnAlarmPick) ((AbstractSchemaElementImpl<?>)a).getModel());
	}

}
