/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class CorrelationValidatorImpl implements CorrelationValidator {

	private Correlation correlation = null;

	public CorrelationValidatorImpl(final Correlation correlation) {
		this.correlation = correlation;
	}

	public void validate() {
		// validation

		// validation if null or empty
		if((this.correlation.getSet() == null) || (this.correlation.getSet().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlation, new BPELException("In Correlation => The set cannot be null or empty")));
		}


		// restriction
		if((this.correlation.getInitiate() != null) && this.correlation.getInitiate().equals(TInitiate.JOIN)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.correlation, "In Correlation => [BPEL engine restriction] The join value in initiate attribute is not supported for the moment"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlation, new BPELException("In Correlation => [BPEL engine restriction] The join value in initiate attribute is not supported for the moment")));
		}
		if(this.correlation.getPattern() != null) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.correlation, "In Correlation => [BPEL engine restriction] The pattern attribute is not supported for the moment"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlation, new BPELException("In Correlation => [BPEL engine restriction] The pattern attribute is not supported for the moment")));
		}

		//validation on content
		final BPELProcess process = ScopeUtil.getProcess((this.correlation));

		if(this.correlation.getSet() != null) {
			final CorrelationSet correlationSet = process.getCorrelationSet(this.correlation.getSet());
			if(correlationSet == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.correlation, new BPELException("In Correlation => Impossible to find the correlation set corresponding to this name " + this.correlation.getSet())));
			}

		}

	}

}
