/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnAlarmValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class OnAlarmValidatorImpl implements OnAlarmValidator {

	private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());

	private OnAlarm alarm = null;
	private TOnAlarmPick model = null;

	public OnAlarmValidatorImpl(final OnAlarm onAlarm) {
		this.alarm = onAlarm;
		this.model = (TOnAlarmPick) ((BPELElementImpl<?>)onAlarm).getModel();
	}

	public void validate() {
		// validation
		log.finest("validate onAlarm");
		
		if(model.getFor()==null && model.getUntil()==null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(alarm, new BPELException("In OnAlarm => A OnAlarm must define either a date or a duration as a termination condition (None of these is defined in this OnAlarm).")));
		}
		
		if(model.getFor()!=null && model.getUntil()!=null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(alarm, new BPELException("In OnAlarm => A OnAlarm must define either a date or a duration as a termination condition (both are defined in this Onalarm).")));
		}
	}

}
